# 带分数

**问题描述**

100 可以表示为带分数的形式：100 = 3 + 69258 / 714。

还可以表示为：100 = 82 + 3546 / 197。

注意特征：带分数中，数字1~9分别出现且只出现一次（不包含0）。

类似这样的带分数，100 有 11 种表示法。

**输入格式**

从标准输入读入一个正整数N (N<1000*1000)

**输出格式**

程序输出该数字用数码1~9不重复不遗漏地组成带分数表示的全部种数。

注意：不要求输出每个表示，只统计有多少表示法！

**样例输入1**

```
100
```

**样例输出1**

```
11
```

**样例输入2**

```
105
```

**样例输出2**

```
6
```

以下<span style="color:red">错误</span>的一项是？

## aop

### before

```c
#include <bits/stdc++.h>
using namespace std;

```

### after

```c

```

## 答案

```c
int main()
{
    int n, ans = 0;
    scanf("%d", &n);
    string s = "123456789";
    do
    {
        for (int i = 1; i <= 7; ++i)
        {
            string a = s.substr(0, i);
            int inta = atoi(a.c_str());
            if (inta >= n)
                break;

            for (int j = i; j <= 9 - i; ++j)
            {
                string b = s.substr(i, j);
                string c = s.substr(i + j);
                int intb = atoi(b.c_str());
                int intc = atoi(c.c_str());
                if (intb % intc == 0 && inta + intb / intc == n)
                    ans++;
            }
        }
    } while (next_permutation(s.begin(), s.end()));
    printf("%d\n", ans);
    return 0;
}
```
## 选项


### A

```c
int visit[10] = {0};
int s[10];
int ans = 0;
int N;
void found(int s[])
{
    int x, y, z;
    for (int i = 1; i < 9; i++)
    {
        for (int j = i + 1; j < 9; j++)
        {
            x = y = z = 0;
            for (int k = 0; k < 9; k++)
            {
                if (k < i)
                    x = x * 10 + s[k + 1];
                else if (k < j)
                    y = y * 10 + s[k + 1];
                else
                    z = z * 10 + s[k + 1];
            }
            if (y % z == 0 && x + y / z == N)
            {
                ans++;
            }
        }
    }
}

void dfs(int pos, int n)
{
    if (pos == n)
        found(s);
    else
    {
        for (int i = 1; i <= 9; i++)
        {
            if (!visit[i])
            {
                s[pos] = i;
                visit[i] = 1;
                dfs(pos + 1, n);
                visit[i] = 0;
            }
        }
    }
}
int main()
{
    cin >> N;
    dfs(1, 10);
    cout << ans << endl;
    return 0;
}

```

### B

```c
int parse(const char *arr, int pos, int len)
{
    int ans = 0;
    int t = 1;
    for (int i = pos + len - 1; i >= pos; i--)
    {
        ans += (arr[i] - '0') * t;
        t *= 10;
    }
    return ans;
}

int main()
{
    int N;
    cin >> N;
    int ans = 0;
    string s = "123456789";
    do
    {
        const char *str = s.c_str();
        for (int i = 0; i <= 7; i++)
        {

            int inta = parse(str, 0, i);

            if (inta >= N)
                break;
            for (int j = 1; j <= 9 - 1 - i; j++)

            {

                int intb = parse(str, i, j);
                int intc = parse(str, i + j, 9 - i - j);
                if (intb % intc == 0 && inta + intb / intc == N)
                {
                    ans++;
                }
            }
        }
    } while (next_permutation(s.begin(), s.end()));

    cout << ans;
    return 0;
}
```

### C

```c
int a[10] = {0};
int Division(int m)
{
    int t;
    while (m)
    {
        t = m % 10;
        if (t == 0)
        {
            return 0;
        }
        a[t]++;
        m = m / 10;
    }
    return 1;
}
int main()
{
    int i, k, j;
    int number, ans = 0, flag;
    cin >> number;
    for (i = 1; i < number; i++)
    {
        for (j = 1; j <= 4938; j++)
        {
            memset(a, 0, sizeof(a));
            k = (number - i) * j;
            if (Division(i) && Division(j) && Division(k))
            {
                flag = 1;
                for (int x = 1; x < 10; x++)
                {
                    if (a[x] != 1)
                    {
                        flag = 0;
                        break;
                    }
                }
                if (flag == 1)
                    ans++;
            }
        }
    }
    cout << ans;
    return 0;
}
```
