# 成绩分析

**问题描述**

小蓝给学生们组织了一场考试，卷面总分为100分，每个学生的得分都是一个0到100的整数。

请计算这次考试的最高分、最低分和平均分。

**输入格式**

输入的第一行包含一个整数n，表示考试人数。

接下来n行，每行包含一个0至100的整数，表示一个学生的得分。

**输出格式**

输出三行。

第一行包含一个整数，表示最高分。

第二行包含一个整数，表示最低分。

第三行包含一个实数，四舍五入保留正好两位小数，表示平均分。

**样例输入**

```json
7
80
92
56
74
88
99
10
```

**样例输出**

```json
99
10
71.29
```

以下选项<span style="color:red">错误</span>的是？

## aop

### before

```c
#include <bits/stdc++.h>
using namespace std;
```

### after

```c

```

## 答案

```c
int main()
{
    int n;
    cin >> n;

    int maxv = 0, minv = 100, sum = 0;
    for (int i = 0; i < n; i++)
    {
        int x;
        cin >> x;
        minv = min(minv, x);
        maxv = max(maxv, x);
        sum += x;
    }

    cout << maxv << endl;
    cout << minv << endl;
    printf("%.2f", sum / n);
    return 0;
}
```

## 选项


### A

```c
int main()
{
    int n, max = 0, min = 0;
    double sum = 0, average = 0;
    cin >> n;
    int a[10000];
    cin >> a[0];
    sum = a[0];
    max = a[0];
    min = a[0];
    for (int i = 1; i < n; i++)
    {
        cin >> a[i];
        if (max < a[i])
        {
            max = a[i];
        }
        if (min > a[i])
        {
            min = a[i];
        }
        sum += a[i];
    }
    average = sum / n;
    cout << max << endl
         << min << endl
         << setiosflags(ios::fixed) << setprecision(2) << average;

    return 0;
}
```

### B

```c
int n;

int Max(int m[10005])
{
    int max = m[0];
    for (int i = 1; i < n; i++)
    {
        if (max < m[i])
        {
            max = m[i];
        }
    }
    return max;
}

int Min(int m[10005])
{
    int min = m[0];
    for (int i = 1; i < n; i++)
    {
        if (min > m[i])
        {
            min = m[i];
        }
    }
    return min;
}

int main()
{
    cin >> n;
    int m[10005];
    for (int i = 0; i < n; i++)
    {
        cin >> m[i];
    }

    int ans = 0;

    for (int i = 0; i < n; i++)
    {
        ans += m[i];
    }

    int a = Max(m);
    int b = Min(m);

    cout << "最高分 = " << a << endl;
    cout << "最低分 = " << b << endl;
    printf("%.2lf", 1.0 * ans / n);
    return 0;
}
```

### C

```c
int main()
{
    int n;
    cin >> n;
    int sum = 0;
    int top = 0;
    int low = 100;

    int score;
    for (int i = 0; i < n; i++)
    {
        cin >> score;
        if (score > top)
            top = score;
        if (score < low)
            low = score;
        sum += score;
    }
    printf("%d\n%d\n%.2lf", top, low, (sum * 1.0 / n));
    return 0;
}
```
