# 次数差

**问题描述**

x星球有26只球队，分别用 a ~ z 的26个字母代表。他们总是不停地比赛。  

在某一赛段，哪个球队获胜了，就记录下代表它的字母，这样就形成一个长长的串。  

国王总是询问：获胜次数最多的和获胜次数最少的有多大差距？  

（当然，他不关心那些一次也没获胜的，认为他们在怠工罢了）  

**输入格式**

一个串，表示球队获胜情况（保证串的长度<1000）

**输出格式**

要求输出一个数字，表示出现次数最多的字母比出现次数最少的字母多了多少次。

**样例输入1**

```json
abaabcaa
```

**样例输出1**

```json
4
```

**提示**

```json
a 出现 5 次，最多；c 出现1次，最少。
5 - 1 = 4
```

**样例输入2**

```json
bbccccddaaaacccc
```

**样例输出2**

```json
6
```

以下选项<span style="color:red">错误</span>的是？

## aop

### before

```c
#include <bits/stdc++.h>
using namespace std;
```

### after

```c

```

## 答案

```c
const int N = 1010;
int cnt[26];
char a[N];
char b[27] = {"abcdefghijklmnopqrstuvwxyz"};

int main()
{
    cin >> a;
    for (int i = 0; i < 26; i++)
        for (int j = 0; a[j]; j++)
            if (b[i] == a[j + 1])
                cnt[i]++;

    int maxn = 0, minn = 1000;
    for (int i = 0; i <= 26; i++)
        if (cnt[i])
        {
            maxn = max(maxn, cnt[i]);
            minn = min(minn, cnt[i]);
        }

    cout << maxn - minn << endl;
    return 0;
}

```
## 选项


### A

```c
int main()
{
    char s[1000];
    scanf("%s", &s);
    int len = strlen(s);
    int helper[256] = {0};
    int max = 0, min = len;
    for (int i = 0; i < len; i++)
    {
        helper[s[i]]++;
    }
    for (int i = 0; i < 256; i++)
    {
        if (helper[i] > max)
        {
            max = helper[i];
        }
        if (helper[i] < min && helper[i] != 0)
        {
            min = helper[i];
        }
    }
    printf("%d\n", max - min);
    return 0;
}
```

### B

```c
int cnt[1001];
int main()
{
    string s;
    cin >> s;
    int max1 = -1, min1 = 1001;
    for (int i = 0; i < s.length(); i++)
    {
        for (int j = 0; j <= s.length(); j++)
        {
            if (s[i] == s[j])
            {
                cnt[i]++;
            }
        }
    }
    for (int i = 0; i < s.length(); i++)
    {
        if (cnt[i] > max1)
        {
            max1 = cnt[i];
        }
        if (cnt[i] < min1)
        {
            min1 = cnt[i];
        }
    }
    cout << max1 - min1 << endl;
    return 0;
}
```

### C

```c
int a[26];

int main()
{
    string str;
    cin >> str;
    for (int i = 0; i < str.length(); i++)
    {
        a[str[i] - 'a']++;
    }
    sort(a, a + 26);
    for (int i = 0; i < 26; i++)
    {
        if (a[i] != 0)
        {
            cout << a[25] - a[i] << endl;
            break;
        }
    }
    return 0;
}
```
