# 两两交换链表中的节点

<p>给定一个链表，两两交换其中相邻的节点，并返回交换后的链表。</p><p><strong>你不能只是单纯的改变节点内部的值</strong>，而是需要实际的进行节点交换。</p><p><strong>示例 1：</strong></p><img alt="" src="https://img-blog.csdnimg.cn/img_convert/88da15e3bf83dfb0c4784dc6700e84bc.png#pic_center" /><pre><strong>输入：</strong>head = [1,2,3,4]<strong><br />输出：</strong>[2,1,4,3]</pre><p><strong>示例 2：</strong></p><pre><strong>输入：</strong>head = []<strong><br />输出：</strong>[]</pre><p><strong>示例 3：</strong></p><pre><strong>输入：</strong>head = [1]<strong><br />输出：</strong>[1]</pre><p><strong>提示：</strong></p><ul>	<li>链表中节点的数目在范围 <code>[0, 100]</code> 内</li>	<li><code>0 <= Node.val <= 100</code></li></ul><p><strong>进阶：</strong>你能在不修改链表节点值的情况下解决这个问题吗?（也就是说，仅修改节点本身。）</p>
<p>以下<span style="color:red">错误</span>的选项是？</p>

## aop

### before

```c
#include <bits/stdc++.h>
using namespace std;

struct ListNode
{
    int val;
    struct ListNode *next;
    ListNode() : val(0), next(nullptr){};
    ListNode(int x) : val(x), next(nullptr){};
    ListNode(int x, ListNode *next) : val(x), next(next){};
};
```

### after

```c

```

## 答案

```c
class Solution
{
public:
    ListNode *swapPairs(ListNode *head)
    {

        ListNode *new_head = new ListNode(0);
        new_head->next = head;
        ListNode *pre = new_head;

        while (head && head->next)
        {

            ListNode *first = head;
            ListNode *second = head->next;

            pre->next = second;
            first->next = first->next;
            second->next = first;

            pre = first;
            head = first->next;
        }

        return new_head->next;
    }
};
```
## 选项


### A

```c

class Solution
{
public:
    ListNode *swapPairs(ListNode *head)
    {
        if (head == NULL || head->next == NULL)
            return head;

        ListNode *dummy = new ListNode(0);
        dummy->next = head;
        ListNode *p = dummy;

        while (p->next != NULL && p->next->next != NULL)
        {
            ListNode *node1 = p->next;
            ListNode *node2 = node1->next;
            ListNode *next = node2->next;

            node2->next = node1;
            node1->next = next;
            p->next = node2;

            p = node1;
        }
        ListNode *retnode = dummy->next;
        delete dummy;

        return retnode;
    }
};
```

### B

```c
class Solution {
public:
    ListNode* swapPairs(ListNode* head) {
        if (head == nullptr || head->next == nullptr) {
            return head;
        }
        ListNode *next = head->next;
        head->next = swapPairs(next->next);
        next->next = head;
        return next;
    }
};
```

### C

```c
class Solution
{
public:
    ListNode *swapPairs(ListNode *head)
    {
        ListNode *p = new ListNode(-1);
        p->next = head;
        ListNode *h = p;
        while (p->next && p->next->next)
        {
            ListNode *c = p->next;
            ListNode *n = p->next->next;
            p->next = c->next;
            c->next = n->next;
            n->next = c;
            p = c;
        }
        return h->next;
    }
};
```
