# 罗马数字转整数

<div class="notranslate">
    <p>罗马数字包含以下七种字符：&nbsp;<code>I</code>，&nbsp;<code>V</code>，&nbsp;<code>X</code>，&nbsp;<code>L</code>，<code>C</code>，<code>D</code>&nbsp;和&nbsp;<code>M</code>。
    </p>

    <pre><strong>字符</strong>          <strong>数值</strong>
I             1
V             5
X             10
L             50
C             100
D             500
M             1000</pre>

    <p>例如， 罗马数字 2 写做&nbsp;<code>II</code>&nbsp;，即为两个并列的 1。12
        写做&nbsp;<code>XII</code>&nbsp;，即为&nbsp;<code>X</code>&nbsp;+&nbsp;<code>II</code>&nbsp;。 27
        写做&nbsp;&nbsp;<code>XXVII</code>,
        即为&nbsp;<code>XX</code>&nbsp;+&nbsp;<code>V</code>&nbsp;+&nbsp;<code>II</code>&nbsp;。</p>

    <p>通常情况下，罗马数字中小的数字在大的数字的右边。但也存在特例，例如 4 不写做&nbsp;<code>IIII</code>，而是&nbsp;<code>IV</code>。数字 1 在数字 5 的左边，所表示的数等于大数 5
        减小数 1 得到的数值 4 。同样地，数字 9 表示为&nbsp;<code>IX</code>。这个特殊的规则只适用于以下六种情况：</p>

    <ul>
        <li><code>I</code>&nbsp;可以放在&nbsp;<code>V</code>&nbsp;(5) 和&nbsp;<code>X</code>&nbsp;(10) 的左边，来表示 4 和 9。</li>
        <li><code>X</code>&nbsp;可以放在&nbsp;<code>L</code>&nbsp;(50) 和&nbsp;<code>C</code>&nbsp;(100) 的左边，来表示 40
            和&nbsp;90。&nbsp;</li>
        <li><code>C</code>&nbsp;可以放在&nbsp;<code>D</code>&nbsp;(500) 和&nbsp;<code>M</code>&nbsp;(1000) 的左边，来表示&nbsp;400
            和&nbsp;900。</li>
    </ul>

    <p>给你一个整数，将其转为罗马数字。</p>

    <p>&nbsp;</p>

    <p><strong>示例&nbsp;1:</strong></p>

    <pre><strong>输入:</strong>&nbsp;num = 3
<strong><br />输出:</strong> "III"</pre>

    <p><strong>示例&nbsp;2:</strong></p>

    <pre><strong>输入:</strong>&nbsp;num = 4
<strong><br />输出:</strong> "IV"</pre>

    <p><strong>示例&nbsp;3:</strong></p>

    <pre><strong>输入:</strong>&nbsp;num = 9
<strong><br />输出:</strong> "IX"</pre>

    <p><strong>示例&nbsp;4:</strong></p>

    <pre><strong>输入:</strong>&nbsp;num = 58
<strong><br />输出:</strong> "LVIII"
<strong><br />解释:</strong> L = 50, V = 5, III = 3.
    </pre>

    <p><strong>示例&nbsp;5:</strong></p>

    <pre><strong>输入:</strong>&nbsp;num = 1994
<strong><br />输出:</strong> "MCMXCIV"
<strong><br />解释:</strong> M = 1000, CM = 900, XC = 90, IV = 4.</pre>

    <p>&nbsp;</p>

    <p><strong>提示：</strong></p>

    <ul>
        <li><code>1 &lt;= num &lt;= 3999</code></li>
    </ul>
</div>
<p>以下<span style="color:red">错误</span>的选项是？</p>

## aop

### before

```cpp
#include <bits/stdc++.h>
using namespace std;
```
### after

```cpp
int main()
{
    Solution sol;
    cout << sol.romanToInt("LVIII") << endl;
    return 0;
}

```

## 答案

```cpp
class Solution
{
public:
    int getTwoNum(char num1, char num2)
    {

        if (num1 == 'I' && (num2 == 'V' || num2 == 'X'))
        {
            if (num2 == 'V')
            {
                return 4;
            }
            else
            {
                return 9;
            }
        }
        if (num1 == 'X' && (num2 == 'L' || num2 == 'C'))
        {
            if (num2 == 'L')
            {
                return 40;
            }
            else
            {
                return 90;
            }
        }
        if (num1 == 'C' && (num2 == 'D' || num2 == 'M'))
        {
            if (num2 == 'D')
            {
                return 400;
            }
            else
            {
                return 900;
            }
        }
        else
        {
            return -1;
        }
    }

    int romanToInt(string s)
    {

        int index = 0;
        int sum = 0;
        while (index < s.length())
        {
            char romeNum1 = s[index];
            if (index == s.length())
            {
                sum = getNum(romeNum1);
            }
            else
            {
                char romeNum2 = s[index + 1];
                int twosum = getTwoNum(romeNum1, romeNum2);
                if (twosum > 0)
                {
                    sum += twosum;
                    index++;
                }
                else
                {
                    sum = getNum(romeNum1);
                }
            }
            index++;
        }
        return sum;
    }

private:
    int getNum(char roma)
    {
        switch (roma)
        {
        case 'I':
            return 1;
        case 'V':
            return 5;
        case 'X':
            return 10;
        case 'L':
            return 50;
        case 'C':
            return 100;
        case 'D':
            return 500;
        case 'M':
            return 1000;
        default:
            return 0;
        }
    }
};
```
## 选项


### A

```cpp
class Solution
{
public:
    int romanToInt(string s)
    {
        int result = 0;
        int n = s.length();
        for (int i = 0; i < n; i++)
        {
            switch (s[i])
            {
            case 'I':
                if (i < n - 1 && s[i + 1] == 'V')
                {
                    result += 4;
                    i++;
                }
                else if (i < n - 1 && s[i + 1] == 'X')
                {
                    result += 9;
                    i++;
                }
                else
                    result++;
                break;
            case 'V':
                result += 5;
                break;
            case 'X':
                if (i < n - 1 && s[i + 1] == 'L')
                {
                    result += 40;
                    i++;
                }
                else if (i < n - 1 && s[i + 1] == 'C')
                {
                    result += 90;
                    i++;
                }
                else
                    result += 10;
                break;
            case 'L':
                result += 50;
                break;
            case 'C':
                if (i < n - 1 && s[i + 1] == 'D')
                {
                    result += 400;
                    i++;
                }
                else if (i < n - 1 && s[i + 1] == 'M')
                {
                    result += 900;
                    i++;
                }
                else
                    result += 100;
                break;
            case 'D':
                result += 500;
                break;
            case 'M':
                result += 1000;
            }
        }
        return result;
    }
};
```

### B

```cpp
class Solution
{
public:
    int romanToInt(string s)
    {
        int result = 0;
        map<char, int> luomab;

        luomab.insert(map<char, int>::value_type('I', 1));
        luomab.insert(map<char, int>::value_type('V', 5));
        luomab.insert(map<char, int>::value_type('X', 10));
        luomab.insert(map<char, int>::value_type('L', 50));
        luomab.insert(map<char, int>::value_type('C', 100));
        luomab.insert(map<char, int>::value_type('D', 500));
        luomab.insert(map<char, int>::value_type('M', 1000));
        for (int i = 0; i < s.length(); i++)
        {
            if (luomab[s[i]] >= luomab[s[i + 1]])
                result += luomab[s[i]];
            else
            {
                result += (luomab[s[i + 1]] - luomab[s[i]]);
                i++;
            }
        }
        return result;
    }
};
```

### C

```cpp
class Solution
{
public:
    int romanToInt(string s)
    {
        int sum = 0;
        for (int i = 1; i <= s.size(); i++)
        {
            if (s[i - 1] == 'I' && s[i] == 'V')
            {
                sum += 4;
                i++;
            }
            else if (s[i - 1] == 'I' && s[i] == 'X')
            {
                sum += 9;
                i++;
            }
            else if (s[i - 1] == 'X' && s[i] == 'L')
            {
                sum += 40;
                i++;
            }
            else if (s[i - 1] == 'X' && s[i] == 'C')
            {
                sum += 90;
                i++;
            }
            else if (s[i - 1] == 'C' && s[i] == 'D')
            {
                sum += 400;
                i++;
            }
            else if (s[i - 1] == 'C' && s[i] == 'M')
            {
                sum += 900;
                i++;
            }
            else if (s[i - 1] == 'I')
            {
                sum += 1;
            }
            else if (s[i - 1] == 'V')
            {
                sum += 5;
            }
            else if (s[i - 1] == 'X')
            {
                sum += 10;
            }
            else if (s[i - 1] == 'L')
            {
                sum += 50;
            }
            else if (s[i - 1] == 'C')
            {
                sum += 100;
            }
            else if (s[i - 1] == 'D')
            {
                sum += 500;
            }
            else if (s[i - 1] == 'M')
            {
                sum += 1000;
            }
        }
        return sum;
    }
};
```
