# 同构字符串

<p>给定两个字符串 <em><strong>s </strong></em>和 <strong><em>t</em></strong>，判断它们是否是同构的。</p>

<p>如果 <em><strong>s </strong></em>中的字符可以按某种映射关系替换得到 <strong><em>t </em></strong>，那么这两个字符串是同构的。</p>

<p>每个出现的字符都应当映射到另一个字符，同时不改变字符的顺序。不同字符不能映射到同一个字符上，相同字符只能映射到同一个字符上，字符可以映射到自己本身。</p>

<p> </p>

<p><strong>示例 1:</strong></p>

<pre>
<strong>输入：</strong><strong><em>s</em></strong> = <code>"egg", </code><strong><em>t = </em></strong><code>"add"</code>
<strong>输出：</strong>true
</pre>

<p><strong>示例 2：</strong></p>

<pre>
<strong>输入：</strong><strong><em>s</em></strong> = <code>"foo", </code><strong><em>t = </em></strong><code>"bar"</code>
<strong>输出：</strong>false</pre>

<p><strong>示例 3：</strong></p>

<pre>
<strong>输入：</strong><strong><em>s</em></strong> = <code>"paper", </code><strong><em>t = </em></strong><code>"title"</code>
<strong>输出：</strong>true</pre>

<p> </p>

<p><strong>提示：</strong></p>

<ul>
	<li>可以假设 <em><strong>s </strong></em>和 <strong><em>t </em></strong>长度相同。</li>
</ul>

<p>以下<span style="color:red">错误</span>的选项是？</p>

## aop

### before

```cpp
#include <bits/stdc++.h>
using namespace std;
```
### after

```cpp
int main()
{
    Solution sol;
    string a = "egg";
    string b = "add";

    bool res;

    res = sol.isIsomorphic(a, b);
    cout << res;
    return 0;
}
```

## 答案

```cpp
class Solution
{
public:
    bool isIsomorphic(string s, string t)
    {
        if (s.size() != t.size())
            return false;
        for (int i = 0; i < s.size(); i++)
        {
            int pos = s.find_first_of(s[i], i + 1);
            while (pos != -1)
            {
                if (t[i] == t[pos + 1])
                {
                    s.erase(pos, 1);
                    t.erase(pos, 1);
                    pos = s.find_first_of(s[i], pos + 1);
                }
                else
                    return false;
            }
        }
        for (int i = 0; i < t.size(); i++)
        {
            int pos = t.find_first_of(t[i], i + 1);
            while (pos != -1)
            {
                if (s[i] == s[pos + 1])
                {
                    s.erase(pos, 1);
                    t.erase(pos, 1);
                    pos = t.find_first_of(t[i], pos + 1);
                }
                else
                    return false;
            }
        }
        return true;
    }
};
```
## 选项


### A

```cpp
class Solution
{
public:
    bool isIsomorphic(string s, string t)
    {
        if (s.size() != t.size())
            return false;
        for (int i = 0; i < s.size(); i++)
        {
            if (s.find(s[i]) != t.find(t[i]))
                return false;
        }
        return true;
    }
};
```

### B

```cpp
class Solution
{
public:
    bool isIsomorphic(string s, string t)
    {
        if (s.size() != t.size())
            return false;
        for (int i = 0; i < s.size(); i++)
        {
            if (s[i] == s[i + 1])
            {
                s.erase(i + 1, 1);
                i--;
            }
        }
        for (int i = 0; i < t.size(); i++)
        {
            if (t[i] == t[i + 1])
            {
                t.erase(i + 1, 1);
                i--;
            }
        }
        if (s.size() != t.size())
            return false;
        for (int i = 0; i < s.size(); i++)
        {
            int pos = s.find_first_of(s[i], i + 1);
            while (pos != -1)
            {
                if (t[i] == t[pos])
                {
                    s.erase(pos, 1);
                    t.erase(pos, 1);
                    pos = s.find_first_of(s[i], pos + 1);
                }
                else
                    return false;
            }
        }
        return true;
    }
};
```

### C

```cpp
class Solution
{
public:
    bool isIsomorphic(string s, string t)
    {
        unordered_map<char, char> map1;
        unordered_map<char, char> map2;
        int n = s.size();
        for (int i = 0; i < n; i++)
        {
            char x = s[i], y = t[i];
            if ((map1.count(x) && map1[x] != y) || (map2.count(y) && map2[y] != x))
                return false;
            map1[x] = y;
            map2[y] = x;
        }
        return true;
    }
};
```
