# 颠倒的价牌

小李的店里专卖其它店中下架的样品电视机，可称为：样品电视专卖店。
其标价都是4位数字（即千元不等）。
小李为了标价清晰、方便，使用了预制的类似数码管的标价签，只要用颜色笔涂数字就可以了（参见图片）。  
![](https://img-blog.csdnimg.cn/20200315215554485.png)  
这种价牌有个特点，对一些数字，倒过来看也是合理的数字。如：1 2 5 6 8 9 0 都可以。这样一来，如果牌子挂倒了，有可能完全变成了另一个价格，比如：1958 倒着挂就是：8561，差了几千元啊!!  
当然，多数情况不能倒读，比如，1110 就不能倒过来，因为0不能作为开始数字。  
有一天，悲剧终于发生了。某个店员不小心把店里的某两个价格牌给挂倒了。并且这两个价格牌的电视机都卖出去了!
庆幸的是价格出入不大，其中一个价牌赔了2百多，另一个价牌却赚了8百多，综合起来，反而多赚了558元。

请根据这些信息计算：赔钱的那个价牌正确的价格应该是多少？

下面的哪一项是<span style="color:red">错误</span>的？

## aop

### before

```cpp
#include <bits/stdc++.h>
using namespace std;
```
### after

```cpp

```

## 答案

```cpp
int main()
{
    int num1[7] = {0, 1, 2, 5, 6, 8, 9};
    int num2[7] = {0, 1, 2, 5, 9, 8, 6};
    int profit1[1111][2];
    int profit2[1111][2];
    int before_reverse;
    int after_reverse;
    int i = 0;
    int j = 0;
    for (int a = 1; a < 7; a++)
    {
        for (int b = 0; b < 7; b++)
        {
            for (int c = 0; c < 7; c++)
            {
                for (int d = 0; d < 7; d++)
                {
                    before_reverse = num1[a] * 1000 + num1[b] * 100 + num1[c] * 10 + num1[d];
                    after_reverse = num2[d] * 1000 + num2[c] * 100 + num2[b] * 10 + num2[a];

                    if (after_reverse - before_reverse > -300 && after_reverse - before_reverse < -200)

                    {
                        profit1[i][0] = before_reverse;
                        profit1[i][1] = after_reverse - before_reverse;
                        i++;
                    }
                    else if (after_reverse - before_reverse > 800 && after_reverse - before_reverse < 900)

                    {
                        profit1[j][0] = after_reverse - before_reverse;
                        profit2[j][1] = before_reverse;
                        j++;
                    }
                }
            }
        }
    }
    int answer = 0;
    for (int a = 0; a < i; a++)
    {
        for (int b = 0; b < j; b++)
        {
            if (profit1[a][1] + profit2[b][1] == 558)
            {
                answer = profit1[a][0];
            }
        }
    }
    cout << answer << endl;
    return 0;
}
```
## 选项


### A

```cpp
void i2s(int num, string &str)
{
    stringstream ss;
    ss << num;
    ss >> str;
}

void s2i(string &str, int &num)
{
    stringstream ss;
    ss << str;
    ss >> num;
}
char to(char x)
{
    if (x == '6')
        return '9';
    else if (x == '9')
        return '6';
    else
        return x;
}

string reserve(const string &str)
{
    string ans;
    for (int i = 3; i >= 0; i--)
    {
        ans.insert(ans.end(), to(str[i]));
    }
    return ans;
}
struct price
{
    int a, b, c;
};
vector<price> v1;
vector<price> v2;
int main()
{
    int answer = 0;
    for (int i = 1000; i < 10000; i++)
    {
        string str;
        i2s(i, str);
        if (str.find('3') != string::npos || str.find('4') != string::npos || str.find('7') != string::npos || str.rfind('0') == 3)

            continue;
        string r = reserve(str);
        int r_int;
        s2i(r, r_int);
        int plus = r_int - i;
        if (plus > -300 && plus < -200)
        {
            price p = {i, r_int, plus};
            v1.push_back(p);
        }
        else if (plus > 800 && plus < 900)
        {
            price p = {i, r_int, plus};
            v2.push_back(p);
        }

        for (int i = 0; i < v1.size(); i++)
        {
            for (int j = 0; j < v2.size(); j++)
            {
                if (v1[i].c + v2[j].c == 558)
                {
                    answer = v1[i].a;
                }
            }
        }
    }
    cout << answer;
    return 0;
}
```

### B

```cpp
#define ll long long
using namespace std;
int flag(int n)
{
    if (n % 10 == 0)
        return 0;
    while (n > 0)
    {
        int t = n % 10;
        if (t == 3 || t == 4 || t == 7)
            return 0;
        n /= 10;
    }
    return 1;
}
int reverse(int n)
{
    int ans = 0;
    while (n > 0)
    {
        int t = n % 10;
        if (t == 6)
            t = 9;
        else if (t == 9)
            t = 6;
        ans = ans * 10 + t;
        n /= 10;
    }
    return ans;
}
int main()
{
    int ans1, ans2;
    for (int i = 1000; i <= 10000; i++)
    {
        for (int j = 1000; j <= 10000; j++)
        {
            if (flag(i) && flag(j))
            {
                int t1 = i - reverse(i);
                int t2 = j - reverse(j);
                if (t1 > 200 && t1 < 300 && t2 < -800 && t2 > -900 && t2 + t1 == -558)
                {
                    ans1 = i, ans2 = j;
                    cout << ans1 << endl;
                    break;
                }
            }
        }
    }
    return 0;
}
```

### C

```cpp
int num[] = {0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
int dnum[] = {0, 1, 2, -1, -1, 5, 9, -1, 8, 6};
int main()
{
    int a[10], b[10];
    int answer = 0;
    for (a[1] = 1; a[1] <= 9; ++a[1])
        for (a[2] = 0; a[2] <= 9; ++a[2])
            for (a[3] = 0; a[3] <= 9; ++a[3])
                for (a[4] = 1; a[4] <= 9; ++a[4])
                {
                    if (dnum[a[1]] >= 0 && dnum[a[2]] >= 0 && dnum[a[3]] >= 0 && dnum[a[3]] >= 0)
                    {
                        int x = a[1] * 1000 + a[2] * 100 + a[3] * 10 + a[4];
                        int y = dnum[a[4]] * 1000 + dnum[a[3]] * 100 + dnum[a[2]] * 10 + dnum[a[1]];
                        if (x - y >= 200 && x - y <= 300)
                        {
                            for (b[1] = 1; b[1] <= 9; ++b[1])
                                for (b[2] = 0; b[2] <= 9; ++b[2])
                                    for (b[3] = 0; b[3] <= 9; ++b[3])
                                        for (b[4] = 1; b[4] <= 9; ++b[4])
                                        {
                                            if (dnum[b[1]] >= 0 && dnum[b[2]] >= 0 && dnum[b[3]] >= 0 && dnum[b[3]] >= 0)
                                            {
                                                int i = b[1] * 1000 + b[2] * 100 + b[3] * 10 + b[4];
                                                int j = dnum[b[4]] * 1000 + dnum[b[3]] * 100 + dnum[b[2]] * 10 + dnum[b[1]];
                                                if (j - i >= 800 && j - i <= 900)
                                                {
                                                    if (j - i + y - x == 558)
                                                        answer = x;
                                                }
                                            }
                                        }
                        }
                    }
                }
    cout << answer;
    return 0;
}

```
