# 幸运数


**问题描述**

幸运数是波兰数学家乌拉姆命名的。它采用与生成素数类似的“筛法”生成。  
首先从1开始写出自然数1,2,3,4,5,6,…  
1 就是第一个幸运数。  
我们从2这个数开始。把所有序号能被2整除的项删除，变为：  
1 _ 3 _ 5 _ 7 _ 9 …  
把它们缩紧，重新记序，为：  
1 3 5 7 9 … 。  
这时，3为第2个幸运数，然后把所有能被3整除的序号位置的数删去。注意，是序号位置，不是那个数本身能否被3整除!! 删除的应该是5，11, 17, …  
此时7为第3个幸运数，然后再删去序号位置能被7整除的(19,39,…)  
最后剩下的序列类似：  

```
1, 3, 7, 9, 13, 15, 21, 25, 31, 33, 37, 43, 49, 51, 63, 67, 69, 73, 75, 79, …
```

**输入格式**

输入两个正整数m n, 用空格分开 (m < n < 1000*1000)


**输出格式**

程序输出 位于m和n之间的幸运数的个数（不包含m和n）。

**样例输入1**

```
1 20
```

**样例输出1**

```
5
```

**样例输入2**

```
30 69
```

**样例输出2**

```
8
```

以下<span style="color:red">错误</span>的一项是？

## aop

### before

```cpp
#include <bits/stdc++.h>
using namespace std;
```

### after

```cpp

```

## 答案

```cpp
int m, n;
int len = 0;
int main()
{
    scanf("%d %d", &m, &n);
    vector<int> vc(n);

    for (int i = 1; i < n; i++)
        vc[i] = 2 * i - 1;
    int divided = 2;
    len = n;
    for (int select = 1;; ++select)
    {
        divided = vc[select - 1];

        int num = 1;
        for (int i = 1; i < len; i++)
            if (i % divided != 0)
                vc[num++] = vc[i];
        len = num;

        if (vc[select] > n)
            break;
    }

    int count = 0;
    for (int i = 1; i < n; i++)
    {
        if (vc[i] >= n)
            break;
        if (vc[i] < n && vc[i] > m)
        {
            ++count;
        }
    }
    printf("%d", count);
    return 0;
}
```

## 选项

### A

```cpp
int main()
{
    vector<int> a;
    a.push_back(0);
    int i, m, n, start;
    cin >> m >> n;
    for (i = 1; i < n; i++)
    {
        if (2 * i - 1 >= n)
            break;
        a.push_back(2 * i - 1);
    }
    start = 2;
    int k;
    vector<int> old;
    do
    {
        old.push_back(0);
        if (start > a.size() - 1)
            break;
        k = a[start++];
        if (k > a.size())
            break;
        for (i = 1; i < a.size(); i++)
        {
            if (i % k)
                old.push_back(a[i]);
        }
        a.clear();
        a.assign(old.begin(), old.end());
        old.clear();
    } while (true);

    int sum = 0;
    for (i = 1; i < a.size(); i++)
        if (a[i] > m)
        {
            sum = sum + 1;
        }
    cout << sum << endl;
    return 0;
}
```

### B

```cpp
int a[500005];

int main()
{
    int i, k = 1;
    int m, n, sum = 0;
    int temp;
    cin >> m >> n;
    for (i = 1; i <= 1000000; i += 2)
    {
        a[k++] = i;
    }
    temp = 2;
    while (temp <= 1000)
    {
        int b[500005], t = 1;
        for (i = 1; i < k; i++)
        {
            if (i % a[temp] != 0)
                b[t++] = a[i];
        }
        for (i = 1; i < t; i++)
            a[i] = b[i];
        temp++;
        k = t;
    }
    for (i = 1; i <= n; i++)
    {
        if (a[i] > m && a[i] < n)
        {
            sum++;
        }
    }
    cout << sum << endl;

    return 0;
}
```

### C

```cpp
struct num
{
    int order;
    int value;
};

int main()
{
    int m, n;
    cin >> m >> n;

    vector<num> numbers;
    int count = 1;
    for (int i = 1; i <= n; i++)
    {
        num tempNum;
        tempNum.order = count;
        tempNum.value = i;
        numbers.push_back(tempNum);
        count++;
    }

    int index = 1, tempCount = 1, value = numbers[index].value;

    while (index <= tempCount)
    {
        int j, tempValue = -1;
        tempCount = 1;
        for (j = 1; j < n; j++)
        {
            if (numbers[j].order != -1)
            {

                if (numbers[j].order % value == 0)
                {
                    numbers[j].order = -1;
                }
                else
                {

                    tempCount++;
                    numbers[j].order = tempCount;

                    if (tempCount == index + 1)
                    {
                        tempValue = numbers[j].value;
                    }
                }
            }
        }

        index++;
        value = tempValue;
    }

    int numCount = 0;
    for (int t = 0; t < n; t++)
    {
        if (numbers[t].order != -1 && numbers[t].value > m && numbers[t].value < n)
        {
            numCount++;
        }
    }

    cout << numCount;
    return 0;
}
```
