# 等差素数列


2,3,5,7,11,13,....是素数序列。
类似：7,37,67,97,127,157 这样完全由素数组成的等差数列，叫等差素数数列。
上边的数列公差为30，长度为6。

2004年，格林与华人陶哲轩合作证明了：存在任意长度的素数等差数列。
这是数论领域一项惊人的成果！

有这一理论为基础，请你借助手中的计算机，满怀信心地搜索：

长度为10的等差素数列，其公差最小值是多少？

以下选项<span style="color:red">错误</span>的是？

## aop

### before

```cpp
#include <bits/stdc++.h>
using namespace std;
```
### after

```cpp

```

## 答案

```cpp
const int N = 10010;

int k;
int prime[N];
bool st[N], check[N];

void init()
{
    for (int i = 2; i < N; i++)
        if (!st[i])
        {
            prime[k++] = i;
            check[i] = true;
            for (int j = i + i; j < N; j += i)
                st[j] = true;
        }
}

int main()
{
    init();
    for (int i = 1; i < N; i++)
        for (int j = 0; j < k; j++)
        {
            int k = prime[j], cnt = 1;
            while (check[k + i])
            {
                k += i;
                if (cnt++ == 10)
                {
                    cout << i << endl;
                    return 0;
                }
            }
        }
}
```
## 选项


### A

```cpp
typedef long long ll;
const ll maxn = 1e6 + 50;
ll a[maxn];
bool ok(ll n, ll cha)
{
    for (ll i = 0; i < 10; i++)
    {
        if (!a[n + i * cha])
            return 0;
    }
    return 1;
}

int main()
{
    a[1] = 0;
    a[2] = 1;
    a[3] = 1;
    for (ll i = 4; i <= 1000000; i++)
    {
        bool flag = 0;
        for (ll j = 2; j * j <= i; j++)
        {
            if (i % j == 0)
            {
                flag = 1;
                break;
            }
        }
        if (flag)
            a[i] = 0;
        else
            a[i] = 1;
    }

    for (ll cha = 1;; cha++)
    {
        for (ll i = 2; i < 1000000; i++)
        {
            if (a[i] && ok(i, cha))
            {
                printf("%lld\n", cha);
                return 0;
            }
        }
    }
}
```

### B

```cpp
const int N = 10001;
int prime[N]{0};

int main()
{

    for (int i = 2; i != N; ++i)
        prime[i] = 1;

    for (int i = 2; i < N; ++i)
    {
        for (int j = i + 1; j < N; ++j)
        {
            if (j % i == 0)
            {
                if (prime[j] == 1)
                    prime[j] = 0;
            }
        }
    }

    for (int d = 1; d <= 300; ++d)
    {
        for (int i = 2; i < N; ++i)
        {
            int a1 = i, flag = 1, len = 1;
            while (len < 10)
            {
                if (prime[a1 + len * d] == 0)
                {
                    flag = 0;
                    break;
                }
                else
                {

                    ++len;
                }
            }

            if (flag)
            {
                cout << d << endl;
                break;
            }
        }
    }

    return 0;
}
```

### C

```cpp
typedef long long LL;
set<int> all;

bool isPrimt(LL t)
{
    for (int i = 2; i < t / 2; ++i)
    {
        if (t % i == 0)
            return false;
    }
    return true;
}

int f(LL a[], int n)
{
    for (int i = 0; i < n; ++i)
    {
        LL first = a[i];
        for (int delta = 1; delta < a[n] - first; ++delta)
        {
            int m = first;
            for (int j = 1; j < 10; ++j)
            {
                m += delta;
                if (all.find(m) == all.end())
                    break;
                if (j == 9)
                    return delta;
            }
        }
    }
    return -1;
}

const int N = 5000;
int main()
{
    LL a[N];

    a[0] = 2;
    a[1] = 3;
    all.insert(2);
    all.insert(3);

    int index = 2;
    LL t = 5;
    while (index < N)
    {
        if (isPrimt(t))
        {
            a[index++] = t;
            all.insert(t);
        }
        t++;
    }

    printf("%d\n", f(a, N));
    return 0;
}

```
