# 矩阵置零

<p>给定一个 <code><em>m</em> x <em>n</em></code> 的矩阵，如果一个元素为 <strong>0 </strong>，则将其所在行和列的所有元素都设为 <strong>0</strong> 。请使用 <strong><a href="http://baike.baidu.com/item/%E5%8E%9F%E5%9C%B0%E7%AE%97%E6%B3%95" target="_blank">原地</a></strong> 算法<strong>。</strong></p><p><strong>进阶：</strong></p><ul>	<li>一个直观的解决方案是使用  <code>O(<em>m</em><em>n</em>)</code> 的额外空间，但这并不是一个好的解决方案。</li>	<li>一个简单的改进方案是使用 <code>O(<em>m</em> + <em>n</em>)</code> 的额外空间，但这仍然不是最好的解决方案。</li>	<li>你能想出一个仅使用常量空间的解决方案吗？</li></ul><p> </p><p><strong>示例 1：</strong></p><img alt="" src="https://cdn.jsdelivr.net/gh/doocs/leetcode@main/solution/0000-0099/0073.Set%20Matrix%20Zeroes/images/mat1.jpg" style="width: 450px; height: 169px;" /><pre><strong>输入：</strong>matrix = [[1,1,1],[1,0,1],[1,1,1]]<strong><br />输出：</strong>[[1,0,1],[0,0,0],[1,0,1]]</pre><p><strong>示例 2：</strong></p><img alt="" src="https://cdn.jsdelivr.net/gh/doocs/leetcode@main/solution/0000-0099/0073.Set%20Matrix%20Zeroes/images/mat2.jpg" style="width: 450px; height: 137px;" /><pre><strong>输入：</strong>matrix = [[0,1,2,0],[3,4,5,2],[1,3,1,5]]<strong><br />输出：</strong>[[0,0,0,0],[0,4,5,0],[0,3,1,0]]</pre><p> </p><p><strong>提示：</strong></p><ul>	<li><code>m == matrix.length</code></li>	<li><code>n == matrix[0].length</code></li>	<li><code>1 <= m, n <= 200</code></li>	<li><code>-2<sup>31</sup> <= matrix[i][j] <= 2<sup>31</sup> - 1</code></li></ul>
<p>以下错误的选项是？</p>

## aop

### before

```cpp
#include <bits/stdc++.h>
using namespace std;
```
### after

```cpp
int main()
{
    Solution sol;
    int a = 3, b = 3;

    vector<vector<int>> matrix = vector<vector<int>>(a, vector<int>(b)) = {{1, 1, 1}, {1, 0, 1}, {1, 1, 1}};
    sol.setZeroes(matrix);
    for (auto i : matrix)
    {
        for (auto j : i)
            cout << j << " ";
        cout << endl;
    }
    return 0;
}
```

## 答案

```cpp
class Solution
{
public:
    void setZeroes(vector<vector<int>> &matrix)
    {
        int row = matrix.size();
        int col = matrix[0].size();
        vector<int> pos;

        for (int i = 0; i < row; i++)
        {
            for (int j = 0; j < col; j++)
            {
                if (matrix[i][j] == 0)
                {
                    pos.push_back(i);
                    pos.push_back(j);
                }
            }
        }

        for (int i = 1; i < pos.size(); i += 2)
        {
            int x = pos[i];
            int y = pos[i + 1];

            for (int j = 0; j < row; j++)
            {
                matrix[j][y] = 0;
            }
            for (int k = 0; k < col; k++)
            {
                matrix[x][k] = 0;
            }
        }
    }
};
```

## 选项


### A

```cpp
class Solution
{
public:
    void setZeroes(vector<vector<int>> &matrix)
    {
        if (matrix.size() <= 0)
            return;

        int row = -1, col = -1;

        int i = 0;

        for (i = 0; i < matrix.size(); i++)
        {
            for (int j = 0; j < matrix[0].size(); j++)
            {
                if (matrix[i][j] == 0)
                {
                    row = i;
                    col = j;
                    break;
                }
            }
            if (row != -1)
                break;
        }

        if (i == matrix.size())
            return;

        for (int k = i + 1; k < matrix.size(); k++)
        {
            for (int j = 0; j < matrix[0].size(); j++)
            {
                if (matrix[k][j] == 0)
                {
                    matrix[row][j] = 0;
                    matrix[k][col] = 0;
                }
            }
        }

        for (i = 0; i < matrix[0].size(); i++)
        {
            if (i == col)
                continue;
            if (matrix[row][i] == 0)
                for (int j = 0; j < matrix.size(); j++)
                    matrix[j][i] = 0;
        }

        for (i = 0; i < matrix.size(); i++)
        {
            if (i == row)
                continue;
            if (matrix[i][col] == 0)
                for (int j = 0; j < matrix[0].size(); j++)
                    matrix[i][j] = 0;
        }

        for (i = 0; i < matrix.size(); i++)
            matrix[i][col] = 0;
        for (i = 0; i < matrix[0].size(); i++)
            matrix[row][i] = 0;
    }
};
```

### B

```cpp
class Solution
{
public:
    void setZeroes(vector<vector<int>> &matrix)
    {
        bool row = false, col = false;
        int m = matrix.size(), n = matrix[0].size();
        for (int i = 0; i < m; ++i)
        {
            if (matrix[i][0] == 0)
                col = true;
        }
        for (int i = 0; i < n; ++i)
        {
            if (matrix[0][i] == 0)
                row = true;
        }
        for (int i = 1; i < m; ++i)
            for (int j = 1; j < n; ++j)
            {
                if (matrix[i][j] == 0)
                    matrix[i][0] = 0, matrix[0][j] = 0;
            }
        for (int i = 1; i < m; ++i)
            for (int j = 1; j < n; ++j)
            {
                if (matrix[i][0] == 0 || matrix[0][j] == 0)
                    matrix[i][j] = 0;
            }
        if (col)
        {
            for (int i = 0; i < m; ++i)
                matrix[i][0] = 0;
        }
        if (row)
        {
            for (int i = 0; i < n; ++i)
                matrix[0][i] = 0;
        }
    }
};
```

### C

```cpp
class Solution
{
public:
    void setZeroes(vector<vector<int>> &matrix)
    {
        int m = matrix.size(), n = matrix[0].size();
        vector<bool> row(m, false), column(n, false);
        int i, j;
        for (i = 0; i < m; i++)
        {
            for (j = 0; j < n; j++)
            {
                if (matrix[i][j] == 0)
                {
                    row[i] = true;
                    column[j] = true;
                }
            }
        }
        for (i = 0; i < m; i++)
        {
            if (row[i])
            {
                for (j = 0; j < n; j++)
                    matrix[i][j] = 0;
            }
        }
        for (i = 0; i < n; i++)
        {
            if (column[i])
            {
                for (j = 0; j < m; j++)
                    matrix[j][i] = 0;
            }
        }
    }
};
```
