# 克隆图

<p>给你无向&nbsp;<strong><a href="https://baike.baidu.com/item/连通图/6460995?fr=aladdin" target="_blank">连通</a>&nbsp;</strong>图中一个节点的引用，请你返回该图的&nbsp;<a href="https://baike.baidu.com/item/深拷贝/22785317?fr=aladdin" target="_blank"><strong>深拷贝</strong></a>（克隆）。</p>

<p>图中的每个节点都包含它的值 <code>val</code>（<code>int</code>） 和其邻居的列表（<code>list[Node]</code>）。</p>

<pre>class Node {
    public int val;
    public List&lt;Node&gt; neighbors;
}</pre>

<p>&nbsp;</p>

<p><strong>测试用例格式：</strong></p>

<p>简单起见，每个节点的值都和它的索引相同。例如，第一个节点值为 1（<code>val = 1</code>），第二个节点值为 2（<code>val = 2</code>），以此类推。该图在测试用例中使用邻接列表表示。</p>

<p><strong>邻接列表</strong> 是用于表示有限图的无序列表的集合。每个列表都描述了图中节点的邻居集。</p>

<p>给定节点将始终是图中的第一个节点（值为 1）。你必须将&nbsp;<strong>给定节点的拷贝&nbsp;</strong>作为对克隆图的引用返回。</p>

<p>&nbsp;</p>

<p><strong>示例 1：</strong></p>

<p><img alt="" src="https://assets.leetcode-cn.com/aliyun-lc-upload/uploads/2020/02/01/133_clone_graph_question.png" style="height: 500px; width: 500px;"></p>

<pre><strong>输入：</strong>adjList = [[2,4],[1,3],[2,4],[1,3]]
<strong>输出：</strong>[[2,4],[1,3],[2,4],[1,3]]
<strong>解释：
</strong>图中有 4 个节点。
节点 1 的值是 1，它有两个邻居：节点 2 和 4 。
节点 2 的值是 2，它有两个邻居：节点 1 和 3 。
节点 3 的值是 3，它有两个邻居：节点 2 和 4 。
节点 4 的值是 4，它有两个邻居：节点 1 和 3 。
</pre>

<p><strong>示例 2：</strong></p>

<p><img alt="" src="https://assets.leetcode-cn.com/aliyun-lc-upload/uploads/2020/02/01/graph.png" style="height: 148px; width: 163px;"></p>

<pre><strong>输入：</strong>adjList = [[]]
<strong>输出：</strong>[[]]
<strong>解释：</strong>输入包含一个空列表。该图仅仅只有一个值为 1 的节点，它没有任何邻居。
</pre>

<p><strong>示例 3：</strong></p>

<pre><strong>输入：</strong>adjList = []
<strong>输出：</strong>[]
<strong>解释：</strong>这个图是空的，它不含任何节点。
</pre>

<p><strong>示例 4：</strong></p>

<p><img alt="" src="https://assets.leetcode-cn.com/aliyun-lc-upload/uploads/2020/02/01/graph-1.png" style="height: 133px; width: 272px;"></p>

<pre><strong>输入：</strong>adjList = [[2],[1]]
<strong>输出：</strong>[[2],[1]]</pre>

<p>&nbsp;</p>

<p><strong>提示：</strong></p>

<ol>
	<li>节点数不超过 100 。</li>
	<li>每个节点值&nbsp;<code>Node.val</code> 都是唯一的，<code>1 &lt;= Node.val &lt;= 100</code>。</li>
	<li>无向图是一个<a href="https://baike.baidu.com/item/简单图/1680528?fr=aladdin" target="_blank">简单图</a>，这意味着图中没有重复的边，也没有自环。</li>
	<li>由于图是无向的，如果节点 <em>p</em> 是节点 <em>q</em> 的邻居，那么节点 <em>q</em> 也必须是节点 <em>p</em>&nbsp;的邻居。</li>
	<li>图是连通图，你可以从给定节点访问到所有节点。</li>
</ol>

<p>以下错误的选项是？</p>

## aop

### before

```cpp
#include <bits/stdc++.h>
using namespace std;

class Node
{
public:
    int val;
    vector<Node *> neighbors;
    Node()
    {
        val = 0;
        neighbors = vector<Node *>();
    }
    Node(int _val)
    {
        val = _val;
        neighbors = vector<Node *>();
    }
    Node(int _val, vector<Node *> _neighbors)
    {
        val = _val;
        neighbors = _neighbors;
    }
};
```
### after

```cpp

```

## 答案

```cpp
class Solution
{
public:
    unordered_map<Node *, Node *> ump;
    Node *cloneGraph(Node *node)
    {
        if (node == nullptr)
            return node;

        if (ump.find(node) == ump.end())
            return ump[node];

        Node *new_node = new Node(node->val);
        ump[node] = new_node;

        for (auto &n : node->neighbors)
        {
            new_node->neighbors.emplace_back(cloneGraph(n));
        }

        return new_node;
    }
};
```

## 选项


### A

```cpp
class Solution
{
public:
    Node *cloneGraph(Node *node)
    {
        if (node == NULL)
            return nullptr;
        queue<Node *> q;
        map<Node *, Node *> visit;
        q.push(node);
        Node *newNode;
        while (!q.empty())
        {
            Node *now = q.front();
            q.pop();
            newNode = new Node(now->val);
            visit[now] = newNode;
            for (auto x : now->neighbors)
            {
                if (!visit.count(x))
                {
                    q.push(x);
                }
            }
        }
        int i = 0;
        for (auto x : visit)
        {
            Node *now = x.first;
            for (auto y : now->neighbors)
            {
                x.second->neighbors.push_back(visit[y]);
            }
        }
        return visit.find(node)->second;
    }
};
```

### B

```cpp
class Solution
{
public:
    map<int, Node *> list;
    Node *cloneGraph(Node *node)
    {
        if (node == NULL)
            return NULL;
        Node *new_node = new Node(node->val, vector<Node *>(node->neighbors.size(), NULL));
        list.insert(map<int, Node *>::value_type(new_node->val, new_node));
        for (int i = 0; i < new_node->neighbors.size(); i++)
        {
            if (list.count(node->neighbors[i]->val) > 0)
                new_node->neighbors[i] = list[node->neighbors[i]->val];
            else
                new_node->neighbors[i] = cloneGraph(node->neighbors[i]);
        }
        return new_node;
    }
};
```

### C

```cpp
class Solution
{
public:
    Node *cloneGraph(Node *node)
    {
        unordered_map<Node *, Node *> m;
        return helper(node, m);
    }
    Node *helper(Node *node, unordered_map<Node *, Node *> &m)
    {
        if (!node)
            return NULL;
        if (m.count(node))
            return m[node];
        Node *clone = new Node(node->val);
        m[node] = clone;
        for (Node *neighbor : node->neighbors)
        {
            clone->neighbors.push_back(helper(neighbor, m));
        }
        return clone;
    }
};
```
