# 字母异位词分组

<p>给定一个字符串数组，将字母异位词组合在一起。字母异位词指字母相同，但排列不同的字符串。</p>
<p><strong>示例:</strong></p>
<pre><strong>输入:</strong>[eat&quot;, &quot;tea&quot;, &quot;tan&quot;, &quot;ate&quot;, &quot;nat&quot;, &quot;bat&quot;]<strong><br />输出:</strong>[[ate&quot;,&quot;eat&quot;,&quot;tea&quot;],[&quot;nat&quot;,&quot;tan&quot;],[&quot;bat&quot;]]</pre>
<p><strong>说明：</strong></p>
<ul>
    <li>所有输入均为小写字母。</li>
    <li>不考虑答案输出的顺序。</li>
</ul>
<p>以下<span style="color:red">错误</span>的选项是？</p>

## aop

### before

```c
#include <bits/stdc++.h>
using namespace std;
```

### after

```c
int main()
{
    Solution sol;
    vector<string> strs = {"eat", "tea", "tan", "ate", "nat", "bat"};
    vector<vector<string>> res;

    res = sol.groupAnagrams(strs);

    for (auto i : res)
    {
        for (auto j : i)
            cout << j << " ";
        cout << endl;
    }
    return 0;
}
```

## 答案

```c
class Solution
{
public:
    vector<vector<string>> groupAnagrams(vector<string> &strs)
    {
        vector<vector<string>> res;
        map<string, int> kvmap;
        string s;
        int index = 0;

        for (int i = 0; i < strs.size(); i++)
        {
            s = strs[i];
            sort(s.begin(), s.end());
            if (kvmap.find(s) == kvmap.end())
            {
                index++;
                res.push_back(vector<string>{});
            }
            res[kvmap[s]].push_back(strs[i]);
        }
        return res;
    }
};
```
## 选项


### A

```c
class Solution
{
public:
    vector<vector<string>> groupAnagrams(vector<string> &strs)
    {
        vector<vector<string>> res;
        unordered_map<string, vector<string>> ht;
        for (const auto &str : strs)
        {
            int counts[26] = {0};
            for (char c : str)
            {
                counts[c - 'a']++;
            }
            string key;
            for (int i : counts)
            {
                key.push_back('#');
                key.push_back(i + '0');
            }
            ht[key].push_back(str);
        }
        for (const auto &t : ht)
        {
            res.push_back(t.second);
        }
        return res;
    }
};
```

### B

```c
class Solution
{
public:
    vector<vector<string>> groupAnagrams(vector<string> &strs)
    {
        map<string, vector<string>> anagram;
        vector<vector<string>> result;
        for (int i = 0; i < strs.size(); i++)
        {
            string str = strs[i];
            sort(str.begin(), str.end());
            if (anagram.find(str) == anagram.end())
            {
                std::vector<string> item;
                anagram[str] = item;
            }
            anagram[str].push_back(strs[i]);
        }
        map<string, vector<string>>::iterator it;
        for (it = anagram.begin(); it != anagram.end(); it++)
        {
            result.push_back((*it).second);
        }
        return result;
    }
};
```

### C

```c
class Solution
{
public:
    vector<vector<string>> groupAnagrams(vector<string> &strs)
    {
        int len = strs.size();
        if (len == 0)
            return {{""}};
        std::map<string, int> mymap;
        vector<vector<string>> ans;
        int cur = 0;
        for (int i = 0; i < len; i++)
        {
            string tmp(strs[i]);
            sort(tmp.begin(), tmp.end());
            std::map<string, int>::iterator it = mymap.find(tmp);
            if (it != mymap.end())
            {
                ans[it->second].push_back(strs[i]);
            }
            else
            {
                vector<string> item;
                item.push_back(strs[i]);
                ans.push_back(item);
                mymap.insert(make_pair(tmp, cur));
                cur++;
            }
        }
        return ans;
    }
};
```
