# 简化路径

<p>给你一个字符串 <code>path</code> ，表示指向某一文件或目录的 Unix 风格 <strong>绝对路径 </strong>（以 <code>'/'</code> 开头），请你将其转化为更加简洁的规范路径。</p><p class="MachineTrans-lang-zh-CN">在 Unix 风格的文件系统中，一个点（<code>.</code>）表示当前目录本身；此外，两个点 （<code>..</code>） 表示将目录切换到上一级（指向父目录）；两者都可以是复杂相对路径的组成部分。任意多个连续的斜杠（即，<code>'//'</code>）都被视为单个斜杠 <code>'/'</code> 。 对于此问题，任何其他格式的点（例如，<code>'...'</code>）均被视为文件/目录名称。</p><p>请注意，返回的 <strong>规范路径</strong> 必须遵循下述格式：</p><ul>	<li>始终以斜杠 <code>'/'</code> 开头。</li>	<li>两个目录名之间必须只有一个斜杠 <code>'/'</code> 。</li>	<li>最后一个目录名（如果存在）<strong>不能 </strong>以 <code>'/'</code> 结尾。</li>	<li>此外，路径仅包含从根目录到目标文件或目录的路径上的目录（即，不含 <code>'.'</code> 或 <code>'..'</code>）。</li></ul><p>返回简化后得到的 <strong>规范路径</strong> 。</p><p><strong>示例 1：</strong></p><pre><strong>输入：</strong>path = "/home/"<strong><br />输出：</strong>"/home"<strong><br />解释：</strong>注意，最后一个目录名后面没有斜杠。 </pre><p><strong>示例 2：</strong></p><pre><strong>输入：</strong>path = "/../"<strong><br />输出：</strong>"/"<strong><br />解释：</strong>从根目录向上一级是不可行的，因为根目录是你可以到达的最高级。</pre><p><strong>示例 3：</strong></p><pre><strong>输入：</strong>path = "/home//foo/"<strong><br />输出：</strong>"/home/foo"<strong><br />解释：</strong>在规范路径中，多个连续斜杠需要用一个斜杠替换。</pre><p><strong>示例 4：</strong></p><pre><strong>输入：</strong>path = "/a/./b/../../c/"<strong><br />输出：</strong>"/c"</pre><p><strong>提示：</strong></p><ul>	<li><code>1 <= path.length <= 3000</code></li>	<li><code>path</code> 由英文字母，数字，<code>'.'</code>，<code>'/'</code> 或 <code>'_'</code> 组成。</li>	<li><code>path</code> 是一个有效的 Unix 风格绝对路径。</li></ul>
<p>以下<span style="color:red">错误</span>的选项是？</p>

## aop

### before

```c
#include <bits/stdc++.h>
using namespace std;
```

### after

```c
int main()
{
    Solution sol;

    string path = "/a/./b/../../c/";
    string res;
    res = sol.simplifyPath(path);
    cout << res;
    return 0;
}
```

## 答案

```c
class Solution
{
public:
    string names[1500];
    int temp = 0, endflag = 0;
    void solve(string s, int start, int end, int n)
    {
        for (int i = start; i < n; i++)
        {
            if (s[i] == '/' && s[i + 1] != '/')
            {
                start = i + 1;
            }
            if (s[i] != '/' && s[i + 1] == '/')
            {
                end = i;
                endflag = 1;
            }
            else if (s[i] != '/' && i == n - 1)
            {
                end = i;
                endflag = 1;
            }
            if (endflag == 1)
            {
                string name = s.substr(start, end - start + 1);
                if (name == "..")
                {
                    if (temp > 0)
                        temp--;
                }
                else
                {
                    temp = temp + 1;
                    names[temp] = name;
                }
                start = end + 1;
                endflag = 0;
            }
        }
    }
    string simplifyPath(string path)
    {
        int n = path.length();
        names[temp] = "*";
        for (int i = n - 1; i >= 0; i++)
        {
            if (path[i] == '/')
                continue;
            if (path[i] != '/')
            {
                path = path.substr(0, i - 0 + 1);
                break;
            }
        }
        solve(path, 0, n - 1, n);
        string str = "";
        if (temp == 0)
        {
            str = "/";
        }
        else
        {
            for (int i = 0; i <= temp - 1; i++)
            {
                if (i == 0)
                {
                    str += "/";
                }
                else
                {
                    str = str + names[i] + "/";
                }
            }
            str = str + names[temp];
        }
        return str;
    }
};
```
## 选项


### A

```c
class Solution
{
public:
    string simplifyPath(string path)
    {
        if (path == "/")
            return "/";

        for (int i = 0; i < path.size(); i++)
        {
            if (path[i] == '/')
                path[i] = ' ';
        }
        vector<string> stack;
        istringstream str(path);
        string buf;
        while (str >> buf)
        {
            if (buf == ".." && !stack.empty())
                stack.pop_back();
            else if (buf != "." && buf != "..")
                stack.push_back(buf);
        }
        if (stack.empty())
            return "/";
        string res;
        for (int i = 0; i < stack.size(); i++)
        {
            res = res + "/" + stack[i];
        }
        return res;
    }
};
```

### B

```c
class Solution
{
public:
    string simplifyPath(string path)
    {
        stringstream ss(path);
        vector<string> strs;
        strs.reserve(20);
        string curr;
        while (getline(ss, curr, '/'))
        {
            if (curr != "." && curr != "")
            {
                if (curr != "..")
                {
                    strs.push_back(curr);
                }
                else if (!strs.empty())
                {
                    strs.pop_back();
                }
            }
        }

        if (!strs.empty())
        {
            string res = "";
            for (string str : strs)
            {
                res.append("/");
                res.append(str);
            }
            return res;
        }
        else
        {

            return "/";
        }
    }
};
```

### C

```c
class Solution
{
public:
    string simplifyPath(string path)
    {
        vector<string> tmp;
        int i = 0;
        while (i < path.size())
        {
            while (path[i] == '/')
                ++i;
            if (i == path.size())
                break;
            int start = i;
            while (path[i] != '/' && i < path.size())
                ++i;
            string s = path.substr(start, i - start);
            if (s == "..")
            {
                if (tmp.size() != 0)
                    tmp.pop_back();
            }
            else if (s != ".")
                tmp.push_back(s);
        }
        if (tmp.empty())
            return "/";
        string ans;
        for (int i = 0; i < tmp.size(); ++i)
            ans += '/' + tmp[i];
        return ans;
    }
};
```
