# 回文日期


**问题描述**

2020 年春节期间，有一个特殊的日期引起了大家的注意：2020年2月2日。因为如果将这个日期按“yyyymmdd” 的格式写成一个8 位数是20200202，恰好是一个回文数。我们称这样的日期是回文日期。  

有人表示20200202 是“千年一遇” 的特殊日子。对此小明很不认同，因为不到2年之后就是下一个回文日期：20211202 即2021年12月2日。  

也有人表示20200202 并不仅仅是一个回文日期，还是一个ABABBABA型的回文日期。对此小明也不认同，因为大约100 年后就能遇到下一个ABABBABA 型的回文日期：21211212 即2121 年12 月12 日。算不上“千年一遇”，顶多算“千年两遇”。  

给定一个8 位数的日期，请你计算该日期之后下一个回文日期和下一个ABABBABA型的回文日期各是哪一天。


**输入格式**

输入包含一个八位整数N，表示日期。


**输出格式**

输出两行，每行1 个八位数。第一行表示下一个回文日期，第二行表示下

一个ABABBABA 型的回文日期。

**样例输入**

```
20200202
```

**样例输出**

```
20211202
21211212
```

**评测用例规模与约定**

对于所有评测用例，10000101 ≤ N ≤ 89991231，保证N 是一个合法日期的8位数表示。

以下选项<span style="color:red">错误</span>的是？


## 答案

```c
#define MAX 110
#define INF 0x3f3f3f3f
#define EXP 1e-9
#define DEUBG 0
#define MOD 1000000007
typedef long long ll;

int n, m, t, k;
int year, dd, mm;
int tbm[2][13] = {0, 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31,
                  0, 31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};

int isrun(int year)
{
    if (year % 100 == 0 && year % 400 == 0)
        return 1;
    else if (year % 100 && year % 4 == 0)
        return 1;
    return 0;
}

int tonum(string s)
{
    int r = 0;
    for (int i = 0; i < s.length(); i++)
    {
        r = r * 10 + s[i] - '0';
    }
    return r;
}

string tostring(int year)
{
    string r = "";
    while (year)
    {
        r = (char)(year % 10 + '0') + r;
        year /= 10;
    }
    return r;
}

int checkyear(int year)
{
    int p = isrun(year);
    string ys = tostring(year);

    reverse(ys.begin(), ys.end());
    int mm = tonum(ys.substr(0, 2));
    int dd = tonum(ys.substr(2, 2));

    if (mm <= 12 && dd <= tbm[p][mm])
        return 1;
    else
        return 0;
}

int checkAB(int year)
{
    int p = isrun(year);
    string ys = tostring(year);
    reverse(ys.begin(), ys.end());
    int mm = tonum(ys.substr(0, 2));
    int dd = tonum(ys.substr(2, 2));
    if (mm == dd && mm <= 12 && dd <= tbm[p][mm])
        return 1;
    else
        return 0;
}

int check(int year, int mm, int dd)
{
    string ys = tostring(year);
    reverse(ys.begin(), ys.end());
    int mt = tonum(ys.substr(0, 2));
    int dt = tonum(ys.substr(2, 2));
    if (mm == mt && dd == dt)
        return 0;
    else
        return 1;
}

void nxtday(int p, int &mm, int &dd)
{
    if (dd < tbm[p][mm])
    {
        dd++;
    }
    else
    {
        mm++;
    }
}

int main()
{
    string s;
    cin >> s;
    year = tonum(s.substr(0, 4));

    int p = isrun(year);
    dd = tonum(s.substr(6, 2));
    mm = tonum(s.substr(4, 2));

    if (check(year, mm, dd))
        year++;
    else
    {
        nxtday(p, mm, dd);
        while (m <= 12 && !check(year, mm, dd))
        {
            nxtday(p, mm, dd);
        }
    }

    while (!checkyear(year))
    {
        year++;
    }
    string t = tostring(year);
    cout << t;
    reverse(t.begin(), t.end());
    cout << t << endl;
    while (!checkAB(year) || !checkyear(year))
    {
        year++;
    }
    t = tostring(year);
    cout << t;
    reverse(t.begin(), t.end());
    cout << t << endl;
    return 0;
}
```

## 选项

### A

```c
const int inf = 0x3fffffff;
const int maxn = 100100;

string i2s(int y, int m, int d)
{

    string str = "";

    str = str + (char)(y / 1000 + '0') + (char)(y / 100 % 10 + '0') + (char)(y / 10 % 10 + '0') + (char)(y % 10 + '0');
    str = str + (char)(m / 10 + '0') + (char)(m % 10 + '0');
    str = str + (char)(d / 10 + '0') + (char)(d % 10 + '0');

    return str;
}

bool judge_1(string str)
{

    int len = str.length();
    int n = len / 2;
    for (int i = 0; i < n; i++)
        if (str[i] != str[len - i - 1])
            return false;

    return true;
}

bool judge_2(string str)
{

    int len = str.length();

    set<char> st;
    for (int i = 0; i < len; i++)
        st.insert(str[i]);

    if (st.size() != 2)
        return false;

    if ((str[0] == str[2] && str[2] == str[5] && str[5] == str[7]) &&
        (str[1] == str[3] && str[3] == str[4] && str[4] == str[6]))

        return true;

    return false;
}

bool isLeap(int y)
{

    if (y % 400 == 0 || (y % 100 != 0 && y % 4 == 0))
        return true;

    return false;
}

int main()
{

    int n;
    int y, m, d;
    cin >> n;

    y = n / 10000;
    m = n / 100 % 100;
    d = n % 100;

    int f1 = 0, f2 = 0;
    while (true)
    {

        d++;

        if (d == 32 && (m == 1 || m == 3 || m == 5 || m == 7 || m == 8 || m == 10 || m == 12))
        {

            d = 1;
            m++;
        }
        else if (d == 31 && (m == 4 || m == 6 || m == 9 || m == 11))
        {

            d = 1;
            m++;
        }
        else if (m == 2)
        {

            if (d == 30 && isLeap(y) == true)
            {
                d = 1;
                m++;
            }
            else if (d == 29 && isLeap(y) == false)
            {

                d = 1;
                m++;
            }
        }

        if (m == 13)
        {

            m = 1;
            y++;
        }

        string str = i2s(y, m, d);

        if (judge_1(str))
        {

            if (f1 == 0)
            {

                cout << str << endl;
                f1 = 1;
            }

            if (judge_2(str))
            {

                cout << str << endl;
                f2 = 1;
            }
        }

        if (f1 && f2)
            break;
    }

    return 0;
}
```

### B

```c
int month[12] = {31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
int data[8];
void guizheng()
{
    int tyear, tmon;
    while (data[3] * 10 + data[2] > 12 || data[3] * 10 + data[2] < 1)
    {
        tyear = data[0] * 1000 + data[1] * 100 + data[2] * 10 + data[3];
        tyear++;
        data[7] = data[0] = tyear / 1000;
        data[6] = data[1] = tyear % 1000 / 100;
        data[5] = data[2] = tyear % 100 / 10;
        data[4] = data[3] = tyear % 10;
    }

    while (data[1] * 10 + data[0] > month[data[3] * 10 + data[2] - 1] || data[1] * 10 + data[0] < 1)
    {
        tmon = data[4] * 1000 + data[5] * 100 + data[6] * 10 + data[7];
        tmon++;
        data[7] = data[0] = tmon / 1000;
        data[6] = data[1] = tmon % 1000 / 100;
        data[5] = data[2] = tmon % 100 / 10;
        data[4] = data[3] = tmon % 10;
    }
}
int zutoshu()
{
    int num;
    num = data[0] * 10000000 + data[1] * 1000000 + data[2] * 100000 + data[3] * 10000 + data[4] * 1000 + data[5] * 100 + data[6] * 10 + data[7];
    return num;
}
int ifABAB()
{
    if (data[0] == data[2] && data[1] == data[3])
        return 0;
    else
        return zutoshu();
}
int main()
{
    int n;
    int tyear;
    scanf("%d", &n);
    n++;
    data[0] = n / 10000000;
    data[1] = n % 10000000 / 1000000;
    data[2] = n % 1000000 / 100000;
    data[3] = n % 100000 / 10000;
    data[4] = n % 10000 / 1000;
    data[5] = n % 1000 / 100;
    data[6] = n % 100 / 10;
    data[7] = n % 10;
    while (data[3] < data[4] || data[2] < data[5] || data[1] < data[6] || data[0] < data[7])
    {
        tyear = data[0] * 1000 + data[1] * 100 + data[2] * 10 + data[3];
        tyear++;
        data[7] = data[0] = tyear / 1000;
        data[6] = data[1] = tyear % 1000 / 100;
        data[5] = data[2] = tyear % 100 / 10;
        data[4] = data[3] = tyear % 10;
        guizheng();
    }
    guizheng();
    printf("%d\n", zutoshu());
    while (ifABAB())
    {
        tyear = data[0] * 1000 + data[1] * 100 + data[2] * 10 + data[3];
        tyear++;
        data[7] = data[0] = tyear / 1000;
        data[6] = data[1] = tyear % 1000 / 100;
        data[5] = data[2] = tyear % 100 / 10;
        data[4] = data[3] = tyear % 10;
    }
    printf("%d\n", zutoshu());
    return 0;
}
```

### C

```c
int days[] = {0, 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};

bool check(int year)
{
    return year % 400 == 0 || year % 4 == 0 && year % 100 != 0;
}

int get_day(int year, int month)
{
    if (month == 2)
        return 28 + check(year);
    return days[month];
}

int main()
{
    int n;
    cin >> n;

    string ans1, ans2;
    bool flag1 = false, flag2 = false;
    for (int i = n / 10000; i <= 9999; i++)
    {
        string a = to_string(i);
        string b = a;
        reverse(b.begin(), b.end());
        if (a + b <= to_string(n))
            continue;

        int month = stoi(b.substr(0, 2));
        int day = stoi(b.substr(2, 2));
        if (month < 1 || month > 12)
            continue;
        if (day < 1 || day > get_day(i, month))
            continue;

        string s1 = a.substr(0, 2);
        string s2 = a.substr(2, 2);
        if (!flag1)
            ans1 = a + b, flag1 = true;
        if (!flag2 && s1 == s2 && s1[0] != s1[1])
            ans2 = a + b, flag2 = true;

        if (flag1 && flag2)
            break;
    }

    cout << ans1 << endl;
    cout << ans2 << endl;
    return 0;
}
```
