# 迷宫

**问题描述**

下图给出了一个迷宫的平面图，其中标记为 1 的为障碍，标记为 0 的为可 以通行的地方。

```
010000
000100
001001
110000
```

迷宫的入口为左上角，出口为右下角，在迷宫中，只能从一个位置走到这 个它的上、下、左、右四个方向之一。 对于上面的迷宫，从入口开始，可以按DRRURRDDDR 的顺序通过迷宫， 一共 10 步。其中 D、U、L、R 分别表示向下、向上、向左、向右走。 对于下面这个更复杂的迷宫（30 行 50 列），请找出一种通过迷宫的方式， 其使用的步数最少，在步数最少的前提下，请找出字典序最小的一个作为答案。 请注意在字典序中D<L<R<U。


**题目数据**

```
01010101001011001001010110010110100100001000101010
00001000100000101010010000100000001001100110100101
01111011010010001000001101001011100011000000010000
01000000001010100011010000101000001010101011001011
00011111000000101000010010100010100000101100000000
11001000110101000010101100011010011010101011110111
00011011010101001001001010000001000101001110000000
10100000101000100110101010111110011000010000111010
00111000001010100001100010000001000101001100001001
11000110100001110010001001010101010101010001101000
00010000100100000101001010101110100010101010000101
11100100101001001000010000010101010100100100010100
00000010000000101011001111010001100000101010100011
10101010011100001000011000010110011110110100001000
10101010100001101010100101000010100000111011101001
10000000101100010000101100101101001011100000000100
10101001000000010100100001000100000100011110101001
00101001010101101001010100011010101101110000110101
11001010000100001100000010100101000001000111000010
00001000110000110101101000000100101001001000011101
10100101000101000000001110110010110101101010100001
00101000010000110101010000100010001001000100010101
10100001000110010001000010101001010101011111010010
00000100101000000110010100101001000001000000000010
11010000001001110111001001000011101001011011101000
00000110100010001000100000001000011101000000110011
10101000101000100010001111100010101001010000001000
10000010100101001010110000000100101010001011101000
00111100001000010000000110111000000001000000001011
10000001100111010111010001000110111010101101111000
```

下面的程序实现了这一功能，请你补全空白处：

```c
#include <bits/stdc++.h>
using namespace std;

char mp[55][55];
int book[55][55];
int block[55][55];
int minns[55][55];
int minn = 100000;
int dx[4] = {1, 0, 0, -1};
int dy[4] = {0, -1, 1, 0};
char dir[4] = {'D', 'L', 'R', 'U'};
char road[1000];
char roadans[1000];
int step;

void dfs(int x, int y, int step)
{
    if (x == 29 && y == 49)
    {
        if (step < minn)
        {
            minn = step;
            for (int i = 0; i < minn; i++)
                roadans[i] = road[i];
        }
        return;
    }

    for (int i = 0; i < 4; i++)
    {
        int tx = x + dx[i];
        int ty = y + dy[i];
        if (tx >= 0 && tx < 30 && ty >= 0 && ty < 50 && book[tx][ty] == 0 && block[tx][ty] == 0 && step + 1 < minns[tx][ty])
        {
            book[tx][ty] = 1;
            road[step] = dir[i];
            minns[tx][ty] = step + 1;
            __________________;
            book[tx][ty] = 0;
        }
    }
    return;
}

int main()
{
    for (int i = 0; i < 30; i++)
    {
        for (int j = 0; j < 50; j++)
        {
            char c;
            cin >> c;
            mp[i][j] = c;
            minns[i][j] = 10000;
            if (c == '1')
                block[i][j] = 1;
        }
    }
    book[0][0] = 1;
    dfs(0, 0, 0);
    for (int i = 0; i < minn; i++)
        cout << roadans[i];

    return 0;
}
```

## 答案

```c
            dfs(tx, ty, step + 1);
```

## 选项

### A

```c
            dfs(tx, ty, step);
```

### B

```c
            dfs(tx + 1, ty + 1, step + 1);
```

### C

```c
            dfs(tx - 1, ty - 1, step + 1);
```
