# 打印图形

小明在X星球的城堡中发现了如下图形和文字：

```
rank=3
   * 
  * * 
 *   *  
* * * *
rank=5
               *                                                      
              * *                                                     
             *   *                                                    
            * * * *                                                   
           *       *                                                  
          * *     * *                                                 
         *   *   *   *                                                
        * * * * * * * *                                               
       *               *                                              
      * *             * *                                             
     *   *           *   *                                            
    * * * *         * * * *                                           
   *       *       *       *  
  * *     * *     * *     * *  
 *   *   *   *   *   *   *   * 
* * * * * * * * * * * * * * * *  
ran=6
                               *                                      
                              * *                                     
                             *   *                                    
                            * * * *                                   
                           *       *                                  
                          * *     * *                                 
                         *   *   *   *                                
                        * * * * * * * *                               
                       *               *                              
                      * *             * *                             
                     *   *           *   *                            
                    * * * *         * * * *                           
                   *       *       *       *                          
                  * *     * *     * *     * *                         
                 *   *   *   *   *   *   *   *                        
                * * * * * * * * * * * * * * * *                       
               *                               *                      
              * *                             * *                     
             *   *                           *   *                    
            * * * *                         * * * *                   
           *       *                       *       *                  
          * *     * *                     * *     * *                 
         *   *   *   *                   *   *   *   *                
        * * * * * * * *                 * * * * * * * *               
       *               *               *               *              
      * *             * *             * *             * *             
     *   *           *   *           *   *           *   *            
    * * * *         * * * *         * * * *         * * * *           
   *       *       *       *       *       *       *       *          
  * *     * *     * *     * *     * *     * *     * *     * *         
 *   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *        
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *     
```  

请你补全程序，实现该图形的打印。

```c
#include <bits/stdc++.h>
using namespace std;

#define N 70

void f(char a[][N], int rank, int row, int col)
{
    if (rank == 1)
    {
        a[row][col] = '*';
        return;
    }

    int w = 1;
    int i;
    for (i = 0; i < rank - 1; i++)
        w *= 2;
    __________________;
    f(a, rank - 1, row + w / 2, col);
    f(a, rank - 1, row + w / 2, col + w);
}

int main()
{
    char a[N][N];
    int i, j;
    for (i = 0; i < N; i++)
        for (j = 0; j < N; j++)
            a[i][j] = ' ';

    f(a, 4, 0, 0);
    for (i = 0; i < N; i++)
    {
        for (j = 0; j < N; j++)
            printf("%c", a[i][j]);
        printf("\n");
    }

    return 0;
}
```


## 答案

```c
f(a, rank - 1, row, col + w / 2);
```
## 选项


### A

```c
f(a, rank, row, col + w / 2);
```

### B

```c
f(a, rank - 1, row, col + w);
```

### C

```c
f(a, rank + 1, row, col + w / 2);
```
