#include <iostream>
#include <algorithm>

using namespace std;
const int N = 1e5 + 10;
int a[N];

int gcd(int a, int b) //辗转相除法 在两个数中求得最大公约数，当一方为0时，返回另一方。
{
    return b ? gcd(b, a % b) : a;
}

int main()
{
    int n;
    cin >> n;
    for (int i = 0; i < n; i++)
        cin >> a[i];

    sort(a, a + n); //回复等差数列正常排序

    int d = 0;
    for (int i = 1; i < n; i++)
        d = gcd(d, a[i] - a[0]); //求得数列中的最大公约数，又因为辗转相除，所以gcd(a,b)中a,b任意一个为零时，可以返回另一个数，再和下一个数求最大公约数。

    if (d)
        cout << (a[n - 1] - a[0]) / d + 1; //特判d为0！即有常数个，否则出现K/d时d==0逻辑错误Float Point Exception
    else
        cout << n;

    return 0;
}
