# 二叉搜索树迭代器

实现一个二叉搜索树迭代器类<code>BSTIterator</code> ，表示一个按中序遍历二叉搜索树（BST）的迭代器：
<div class="original__bRMd">
<div>
<ul>
	<li><code>BSTIterator(TreeNode root)</code> 初始化 <code>BSTIterator</code> 类的一个对象。BST 的根节点 <code>root</code> 会作为构造函数的一部分给出。指针应初始化为一个不存在于 BST 中的数字，且该数字小于 BST 中的任何元素。</li>
	<li><code>boolean hasNext()</code> 如果向指针右侧遍历存在数字，则返回 <code>true</code> ；否则返回 <code>false</code> 。</li>
	<li><code>int next()</code>将指针向右移动，然后返回指针处的数字。</li>
</ul>

<p>注意，指针初始化为一个不存在于 BST 中的数字，所以对 <code>next()</code> 的首次调用将返回 BST 中的最小元素。</p>
</div>
</div>

<p>你可以假设 <code>next()</code> 调用总是有效的，也就是说，当调用 <code>next()</code> 时，BST 的中序遍历中至少存在一个下一个数字。</p>


<p><strong>示例：</strong></p>
<img alt="" src="https://img-blog.csdnimg.cn/img_convert/743f55b78d358ff4ba5fbb7d8088a0d9.png#pic_center" />

<strong>输入</strong>

```
["BSTIterator", "next", "next", "hasNext", "next", "hasNext", "next", "hasNext", "next", "hasNext"]
[[[7, 3, 15, null, null, 9, 20]], [], [], [], [], [], [], [], [], []]
```

<strong>输出</strong>

```
[null, 3, 7, true, 9, true, 15, true, 20, false]
```

<strong>解释</strong>

```java
BSTIterator bSTIterator = new BSTIterator([7, 3, 15, null, null, 9, 20]);
bSTIterator.next();    // 返回 3
bSTIterator.next();    // 返回 7
bSTIterator.hasNext(); // 返回 True
bSTIterator.next();    // 返回 9
bSTIterator.hasNext(); // 返回 True
bSTIterator.next();    // 返回 15
bSTIterator.hasNext(); // 返回 True
bSTIterator.next();    // 返回 20
bSTIterator.hasNext(); // 返回 False
```



<p><strong>提示：</strong></p>

<ul>
	<li>树中节点的数目在范围 <code>[1, 10<sup>5</sup>]</code> 内</li>
	<li><code>0 <= Node.val <= 10<sup>6</sup></code></li>
	<li>最多调用 <code>10<sup>5</sup></code> 次 <code>hasNext</code> 和 <code>next</code> 操作</li>
</ul>



<p><strong>进阶：</strong></p>

<ul>
	<li>你可以设计一个满足下述条件的解决方案吗？<code>next()</code> 和 <code>hasNext()</code> 操作均摊时间复杂度为 <code>O(1)</code> ，并使用 <code>O(h)</code> 内存。其中 <code>h</code> 是树的高度。</li>
</ul>

<p>以下<span style="color:red">错误</span>的选项是？</p>

## aop

### before

```c
#include <bits/stdc++.h>
using namespace std;

struct TreeNode
{
    int val;
    TreeNode *left;
    TreeNode *right;
    TreeNode() : val(0), left(nullptr), right(nullptr) {}
    TreeNode(int x) : val(x), left(nullptr), right(nullptr) {}
    TreeNode(int x, TreeNode *left, TreeNode *right) : val(x), left(left), right(right) {}
};
```

### after

```c
/**
 * Your BSTIterator object will be instantiated and called as such:
 * BSTIterator* obj = new BSTIterator(root);
 * int param_1 = obj->next();
 * bool param_2 = obj->hasNext();
 */
```

## 答案

```c
class BSTIterator
{
private:
    void traverse(TreeNode *root, vector<int> &res)
    {
        if (root == nullptr)
        {
            return;
        }
        traverse(root->right, res);
        traverse(root->left, res);
        res.push_back(root->val);
        }

    vector<int> inorder(TreeNode *root)
    {
        vector<int> res;
        traverse(root, res);
        return res;
    }

    vector<int> arr;
    int idx;

public:
    BSTIterator(TreeNode *root) : idx(0), arr(inorder(root))
    {
    }

    int next()
    {
        return arr[idx++];
    }

    bool hasNext()
    {
        return idx < arr.size();
    }
};
```
## 选项

### A

```c
class BSTIterator
{
private:
    void inorder(TreeNode *root, vector<int> &vec)
    {
        if (!root)
            return;
        inorder(root->left, vec);
        vec.emplace_back(root->val);
        inorder(root->right, vec);
    }
    vector<int> inorderTraversal(TreeNode *root)
    {
        vector<int> ret;
        inorder(root, ret);
        return ret;
    }

    vector<int> buf;
    size_t idx;

public:
    BSTIterator(TreeNode *root)
    {
        idx = 0;
        buf = inorderTraversal(root);
    }

    int next()
    {
        return buf[idx++];
    }

    bool hasNext()
    {
        return idx < buf.size();
    }
};
```

### B

```c
class BSTIterator
{
public:
    stack<TreeNode *> treeMin;
    BSTIterator(TreeNode *root)
    {
        TreeNode *t = root;
        while (t)
        {
            treeMin.push(t);
            t = t->left;
        }
    }

    /** @return the next smallest number */
    int next()
    {
        TreeNode *tmp = treeMin.top();
        int res = tmp->val;
        treeMin.pop();
        tmp = tmp->right;
        while (tmp)
        {
            treeMin.push(tmp);
            tmp = tmp->left;
        }
        return res;
    }

    /** @return whether we have a next smallest number */
    bool hasNext()
    {
        if (treeMin.empty())
            return false;
        else
            return true;
    }
};
```

### C

```c
class BSTIterator
{
public:
    queue<int> q;
    BSTIterator(TreeNode *root)
    {

        inorder(root, q);
    }

    void inorder(TreeNode *root, queue<int> &q)
    {
        if (root == NULL)
            return;
        inorder(root->left, q);
        q.push(root->val);
        inorder(root->right, q);
    }

    /** @return the next smallest number */
    int next()
    {
        int tmp = q.front();
        q.pop();
        return tmp;
    }

    /** @return whether we have a next smallest number */
    bool hasNext()
    {
        if (q.empty())
            return false;
        else
            return true;
    }
};
```
