# 方格分割
6x6的方格，沿着格子的边线剪开成两部分。
要求这两部分的形状完全相同。

如图：  
![](https://img-blog.csdn.net/20180321145603391)
![](https://img-blog.csdn.net/20180321145607269)
![](https://img-blog.csdn.net/20180321145611157)  
就是可行的分割法。

试计算：
包括这3种分法在内，一共有多少种不同的分割方法。
注意：旋转对称的属于同一种分割法。

## aop
### before
```cpp
#include <iostream>
using namespace std;

int ans;
int dire[][2] = {{-1, 0}, {1, 0}, {0, -1}, {0, 1}};
int vis[7][7];
```
### after
```cpp
int main()
{
    dfs(3, 3);
    cout << ans / 4 << endl;
    return 0;
}
```

## 答案
```cpp
void dfs(int x, int y)
{
    if (x == 0 || y == 0 || x == 6 || y == 6)
    {
        ans++;
        return;
    }

    vis[x][y] = 1;

    vis[6 - x][6 - y] = 1;
    for (int k = 0; k < 4; k++)
    {
        int nx = x + dire[k][0];
        int ny = y + dire[k][1];

        if (nx < 0 || nx > 6 || ny < 0 || ny > 6)
            continue;
        if (!vis[nx][ny])
        {
            dfs(nx, ny);
        }
    }
    vis[x][y] = 0;
    vis[6 - x][6 - y] = 0;
}
```
## 选项

### A
```cpp
void dfs(int x, int y)
{
    if (x == 0 || y == 0 || x == 6 || y == 6)
    {
        ans++;
        return;
    }

    vis[x][y] = 1;

    vis[6 - x][6 - y] = 1;
    for (int k = 0; k < 4; k++)
    {
        int nx = x + dire[k][0];
        int ny = y + dire[k][1];

        if (nx < 0 || nx > 6 || ny < 0 || ny > 6)
            continue;
        if (!vis[nx][ny])
        {
            dfs(nx - 1, ny - 1);
        }
    }
    vis[x][y] = 0;
    vis[6 - x][6 - y] = 0;
}
```

### B
```cpp
void dfs(int x, int y)
{
    if (x == 0 || y == 0 || x == 6 || y == 6)
    {
        ans++;
        return;
    }

    vis[x][y] = 1;

    vis[6 - x][6 - y] = 1;
    for (int k = 0; k < 4; k++)
    {
        int nx = x + dire[k][0];
        int ny = y + dire[k][1];

        if (nx < 0 || nx > 6 || ny < 0 || ny > 6)
            continue;
        if (!vis[nx][ny])
        {
            dfs(nx + 1, ny + 1);
        }
    }
    vis[x][y] = 0;
    vis[6 - x][6 - y] = 0;
}
```

### C
```cpp
void dfs(int x, int y)
{
    if (x == 0 || y == 0 || x == 6 || y == 6)
    {
        ans++;
        return;
    }

    vis[x][y] = 1;

    vis[6 - x][6 - y] = 1;
    for (int k = 0; k < 4; k++)
    {
        int nx = x + dire[k][0];
        int ny = y + dire[k][1];

        if (nx < 0 || nx > 6 || ny < 0 || ny > 6)
            continue;
        if (!vis[nx][ny])
        {
            dfs(nx, ny + 1);
        }
    }
    vis[x][y] = 0;
    vis[6 - x][6 - y] = 0;
}
```
