# 分发糖果

<p>老师想给孩子们分发糖果，有 <em>N</em> 个孩子站成了一条直线，老师会根据每个孩子的表现，预先给他们评分。</p>

<p>你需要按照以下要求，帮助老师给这些孩子分发糖果：</p>

<ul>
	<li>每个孩子至少分配到 1 个糖果。</li>
	<li>评分更高的孩子必须比他两侧的邻位孩子获得更多的糖果。</li>
</ul>

<p>那么这样下来，老师至少需要准备多少颗糖果呢？</p>

<p> </p>

<p><strong>示例 1：</strong></p>

<pre>
<strong>输入：</strong>[1,0,2]
<strong>输出：</strong>5
<strong>解释：</strong>你可以分别给这三个孩子分发 2、1、2 颗糖果。
</pre>

<p><strong>示例 2：</strong></p>

<pre>
<strong>输入：</strong>[1,2,2]
<strong>输出：</strong>4
<strong>解释：</strong>你可以分别给这三个孩子分发 1、2、1 颗糖果。
     第三个孩子只得到 1 颗糖果，这已满足上述两个条件。</pre>

<p>以下<span style="color:red">错误</span>的选项是？</p>

## aop

### before

```c
#include <bits/stdc++.h>
using namespace std;
```

### after

```c
int main()
{
    Solution sol;
    vector<int> ratings = {1, 0, 2};
    int res;
    res = sol.candy(ratings);
    cout << res;
    return 0;
}
```

## 答案

```c
class Solution
{
public:
    int candy(vector<int> &ratings)
    {
        int size = ratings.size();
        vector<int> num(size, 1);
        for (int i = 1; i < size; i++)
        {
            if (ratings[i] > ratings[i - 1])
                num[i] = num[i - 1] + 1;
        }
        for (int i = size - 1; i > 0; i--)
        {
            if ((ratings[i] < ratings[i - 1]) && (num[i - 1] <= num[i]))
                num[i - 1] = num[i];
        }
        return accumulate(num.begin(), num.end(), 0);
    }
};
```
## 选项


### A

```c
class Solution
{
public:
    int candy(vector<int> &ratings)
    {
        int n = ratings.size(), sum = 0;
        vector<int> left(n, 1), right(n, 1);
        for (int i = 1; i < n; i++)
        {
            if (ratings[i] > ratings[i - 1])
                left[i] = left[i - 1] + 1;
        }
        for (int i = n - 2; i >= 0; i--)
        {
            if (ratings[i] > ratings[i + 1])
                right[i] = right[i + 1] + 1;
            sum += max(left[i], right[i]);
        }
        sum += max(right[n - 1], left[n - 1]);
        return sum;
    }
};
```

### B

```c
class Solution
{
public:
    int candy(vector<int> &ratings)
    {
        int sum = 0;
        int pre = 0;
        int st = 0;
        int i = 0;
        while (i < ratings.size())
        {
            if (i == 0)
            {
                sum += 1;
                pre = 1;
                st = i;
            }
            else if (ratings[i] > ratings[i - 1])
            {
                pre = pre + 1;
                sum = sum + pre;
                st = i;
            }
            else if (ratings[i] == ratings[i - 1])
            {
                pre = 1;
                sum += pre;
                st = i;
            }
            else
            {
                int k = i;
                while (k < ratings.size() && ratings[k] < ratings[k - 1])
                {
                    k++;
                }
                int m = k - i;
                sum += (m * (m + 1) / 2);
                sum += max(0, m + 1 - pre);
                pre = 1;
                i = k;
                continue;
            }
            i++;
        }
        return sum;
    }
};
```

### C

```c
class Solution
{
public:
    int candy(vector<int> &ratings)
    {
        int len = ratings.size();
        if (len < 2)
            return len;
        int candy[len + 1];
        candy[0] = 1;
        for (int i = 1; i < len; i++)
        {
            if (ratings[i] > ratings[i - 1])
                candy[i] = candy[i - 1] + 1;
            else
                candy[i] = 1;
        }
        int ans = 0;
        for (int i = len - 1; i > 0; i--)
        {
            if (candy[i] >= candy[i - 1] && ratings[i] < ratings[i - 1])
                candy[i - 1] = max(candy[i - 1], candy[i] + 1);
            ans += candy[i];
        }
        return ans + candy[0];
    }
};
```
