# 课程表

<p>你这个学期必须选修 <code>numCourses</code> 门课程，记为 <code>0</code> 到 <code>numCourses - 1</code> 。</p>

<p>在选修某些课程之前需要一些先修课程。 先修课程按数组 <code>prerequisites</code> 给出，其中 <code>prerequisites[i] = [a<sub>i</sub>, b<sub>i</sub>]</code> ，表示如果要学习课程 <code>a<sub>i</sub></code> 则 <strong>必须</strong> 先学习课程  <code>b<sub>i</sub></code><sub> </sub>。</p>

<ul>
	<li>例如，先修课程对 <code>[0, 1]</code> 表示：想要学习课程 <code>0</code> ，你需要先完成课程 <code>1</code> 。</li>
</ul>

<p>请你判断是否可能完成所有课程的学习？如果可以，返回 <code>true</code> ；否则，返回 <code>false</code> 。</p>

<p> </p>

<p><strong>示例 1：</strong></p>

<pre>
<strong>输入：</strong>numCourses = 2, prerequisites = [[1,0]]
<strong>输出：</strong>true
<strong>解释：</strong>总共有 2 门课程。学习课程 1 之前，你需要完成课程 0 。这是可能的。</pre>

<p><strong>示例 2：</strong></p>

<pre>
<strong>输入：</strong>numCourses = 2, prerequisites = [[1,0],[0,1]]
<strong>输出：</strong>false
<strong>解释：</strong>总共有 2 门课程。学习课程 1 之前，你需要先完成​课程 0 ；并且学习课程 0 之前，你还应先完成课程 1 。这是不可能的。</pre>

<p> </p>

<p><strong>提示：</strong></p>

<ul>
	<li><code>1 <= numCourses <= 10<sup>5</sup></code></li>
	<li><code>0 <= prerequisites.length <= 5000</code></li>
	<li><code>prerequisites[i].length == 2</code></li>
	<li><code>0 <= a<sub>i</sub>, b<sub>i</sub> < numCourses</code></li>
	<li><code>prerequisites[i]</code> 中的所有课程对 <strong>互不相同</strong></li>
</ul>

<p>以下<span style="color:red">错误</span>的选项是？</p>

## aop

### before

```c
#include <bits/stdc++.h>
using namespace std;
```

### after

```c

```

## 答案

```c
class Solution
{
public:
    bool canFinish(int numCourses, vector<vector<int>> &prerequisites)
    {

        unordered_map<int, vector<int>> rels;
        int *inDs = new int[numCourses];
        for (int i = 0; i < numCourses; i++)
        {
            inDs[i] = 0;
            vector<int> temp;
            rels[i] = temp;
        }

        for (int i = 0; i < prerequisites.size(); i++)
        {
            rels[prerequisites[i][1]].push_back(prerequisites[i][0]);
            inDs[prerequisites[i][0]]++;
        }
        queue<int> zeroInD;
        int num = 0;
        while (num != numCourses)
        {
            for (int i = 0; i < numCourses; i++)
            {
                if (inDs[i] == 0)
                {
                    zeroInD.push(i);
                    num++;
                    inDs[i] = -1;
                }
            }
            if (zeroInD.empty() && num != numCourses)
                return false;
            while (!zeroInD.empty())
            {
                int topV = zeroInD.front();
                zeroInD.pop();
                vector<int> topVEdges = rels[topV];
                for (int j = 0; j < topVEdges.size(); j++)
                {
                    inDs[topVEdges[j]]++;
                }
            }
        }
        if (num == numCourses)
            return true;
        else
            return false;
    }
};
```
## 选项


### A

```c
class Solution
{
public:
    bool canFinish(int numCourses, vector<vector<int>> &prerequisites)
    {
        if (numCourses == 0)
            return true;

        vector<int> course(numCourses, 0);
        vector<vector<int>> rela(numCourses);
        for (int i = 0; i < prerequisites.size(); i++)
        {
            course[prerequisites[i][0]]++;
            rela[prerequisites[i][1]].push_back(prerequisites[i][0]);
        }

        queue<int> cq;
        for (int i = 0; i < numCourses; i++)
            if (course[i] == 0)
                cq.push(i);

        int num = numCourses;
        while (!cq.empty())
        {
            int c = cq.front();
            cq.pop();
            num--;
            for (int i = 0; i < rela[c].size(); i++)
            {
                int this_course = rela[c][i];
                course[this_course]--;
                if (course[this_course] == 0)
                    cq.push(this_course);
            }
        }
        return num == 0 ? true : false;
    }
};
```

### B

```c
class Solution
{
public:
    bool canFinish(int numCourses, vector<vector<int>> &prerequisites)
    {
        vector<int> res, degree(numCourses, 0);
        unordered_map<int, vector<int>> map;

        for (auto &e : prerequisites)
        {
            map[e[1]].push_back(e[0]);
            degree[e[0]]++;
        }

        queue<int> q;
        for (int i = 0; i < numCourses; i++)
        {
            if (degree[i] == 0)
            {
                q.push(i);
            }
        }
        while (!q.empty())
        {
            int cur = q.front();
            res.push_back(cur);
            q.pop();
            for (auto &next : map[cur])
            {
                degree[next]--;
                if (degree[next] == 0)
                    q.push(next);
            }
        }
        return res.size() == numCourses;
    }
};
```

### C

```c
class Solution
{
public:
    bool canFinish(int numCourses, vector<vector<int>> &prerequisites)
    {

        vector<vector<int>> graph(numCourses, vector<int>());

        for (auto num : prerequisites)
        {
            graph[num[1]].push_back(num[0]);
        }
        vector<int> visit(numCourses);

        for (int i = 0; i < numCourses; i++)
        {
            if (!dfs(graph, visit, i))
                return false;
        }
        return true;
    }
    bool dfs(vector<vector<int>> &g, vector<int> &visit, int i)
    {
        if (visit[i] == -1)
            return false;
        if (visit[i] == 1)
            return true;
        visit[i] = -1;
        for (auto a : g[i])
        {
            if (!dfs(g, visit, a))
                return false;
        }
        visit[i] = 1;
        return true;
    }
};
```
