# 颜色分类

<p>给定一个包含红色、白色和蓝色，一共 <code>n</code><em> </em>个元素的数组，<strong><a href="https://baike.baidu.com/item/%E5%8E%9F%E5%9C%B0%E7%AE%97%E6%B3%95" target="_blank">原地</a></strong>对它们进行排序，使得相同颜色的元素相邻，并按照红色、白色、蓝色顺序排列。</p><p>此题中，我们使用整数 <code>0</code>、 <code>1</code> 和 <code>2</code> 分别表示红色、白色和蓝色。</p><ul></ul><p> </p><p><strong>示例 1：</strong></p><pre><strong>输入：</strong>nums = [2,0,2,1,1,0]<strong><br />输出：</strong>[0,0,1,1,2,2]</pre><p><strong>示例 2：</strong></p><pre><strong>输入：</strong>nums = [2,0,1]<strong><br />输出：</strong>[0,1,2]</pre><p><strong>示例 3：</strong></p><pre><strong>输入：</strong>nums = [0]<strong><br />输出：</strong>[0]</pre><p><strong>示例 4：</strong></p><pre><strong>输入：</strong>nums = [1]<strong><br />输出：</strong>[1]</pre><p> </p><p><strong>提示：</strong></p><ul>	<li><code>n == nums.length</code></li>	<li><code>1 <= n <= 300</code></li>	<li><code>nums[i]</code> 为 <code>0</code>、<code>1</code> 或 <code>2</code></li></ul><p> </p><p><strong>进阶：</strong></p><ul>	<li>你可以不使用代码库中的排序函数来解决这道题吗？</li>	<li>你能想出一个仅使用常数空间的一趟扫描算法吗？</li></ul>
<p>以下<span style="color:red">错误</span>的选项是？</p>

## aop

### before

```c
#include <bits/stdc++.h>
using namespace std;

```

### after

```c
int main()
{
    Solution sol;
    int a = 3, b = 4;

    vector<int> nums = {2, 0, 2, 1, 1, 0};
    sol.sortColors(nums);
    for (auto i : nums)
        cout << i << " ";
    return 0;
}
```

## 答案

```c
class Solution
{
public:
    void sortColors(vector<int> &nums)
    {
        int zero = 0, two = nums.size() - 1;
        int i = 0;
        while (i <= two)
        {
            if (nums[i] <= 1)
            {
                int temp = nums[i];
                nums[i] = nums[zero];
                nums[zero] = temp;
                zero++;
                i++;
            }
            else
            {
                int temp = nums[i];
                nums[i] = nums[two];
                nums[two] = temp;
                two--;
            }
        }
    }
};
```
## 选项


### A

```c
class Solution
{
public:
    void sortColors(vector<int> &nums)
    {
        int p0 = 0;
        int p1 = 0;
        int p2 = nums.size() - 1;
        while (p1 <= p2)
        {
            if (nums[p1] == 0)
                swap(nums[p1++], nums[p0++]);
            else if (nums[p1] == 2)
                swap(nums[p1], nums[p2--]);
            else
                p1++;
        }
    }
};
```

### B

```c
class Solution
{
public:
    void sortColors(vector<int> &nums)
    {
        int a[3] = {0};
        int b[3] = {0, 1, 2};
        int num = 0;
        for (int i = 0; i < nums.size(); i++)
        {
            if (nums[i] == 0)
                a[0]++;
            if (nums[i] == 1)
                a[1]++;
            if (nums[i] == 2)
                a[2]++;
        }
        for (int i = 0; i < 3; i++)
        {
            for (int j = 0; j < a[i]; j++)
            {
                nums[num] = b[i];
                num++;
            }
        }
    }
};
```

### C

```c
class Solution
{
public:
    void sortColors(vector<int> &nums)
    {
        int start = 0;
        int end = nums.size() - 1;
        int temp;
        for (int i = 0; i < nums.size(); i++)
        {
            if (i > end)
                break;
            if (nums[i] == 2)
            {
                if (i == end)
                    continue;
                temp = nums[i];
                nums[i] = nums[end];
                nums[end] = temp;
                end--;
                i--;
            }
            else if (nums[i] == 0)
            {
                if (i == start)
                    continue;
                temp = nums[i];
                nums[i] = nums[start];
                nums[start] = temp;
                start++;
                i--;
            }
        }
    }
};
```
