# 螺旋矩阵

<p>给你一个 <code>m</code> 行 <code>n</code> 列的矩阵 <code>matrix</code> ，请按照 <strong>顺时针螺旋顺序</strong> ，返回矩阵中的所有元素。</p><p> </p><p><strong>示例 1：</strong></p><img alt="" src="https://cdn.jsdelivr.net/gh/doocs/leetcode@main/solution/0000-0099/0054.Spiral%20Matrix/images/spiral1.jpg" style="width: 242px; height: 242px;" /><pre><strong>输入：</strong>matrix = [[1,2,3],[4,5,6],[7,8,9]]<strong><br />输出：</strong>[1,2,3,6,9,8,7,4,5]</pre><p><strong>示例 2：</strong></p><img alt="" src="https://cdn.jsdelivr.net/gh/doocs/leetcode@main/solution/0000-0099/0054.Spiral%20Matrix/images/spiral.jpg" style="width: 322px; height: 242px;" /><pre><strong>输入：</strong>matrix = [[1,2,3,4],[5,6,7,8],[9,10,11,12]]<strong><br />输出：</strong>[1,2,3,4,8,12,11,10,9,5,6,7]</pre><p> </p><p><strong>提示：</strong></p><ul>	<li><code>m == matrix.length</code></li>	<li><code>n == matrix[i].length</code></li>	<li><code>1 <= m, n <= 10</code></li>	<li><code>-100 <= matrix[i][j] <= 100</code></li></ul>
<p>以下<span style="color:red">错误</span>的选项是？</p>

## aop

### before

```c
#include <bits/stdc++.h>
using namespace std;
```

### after

```c

```

## 答案

```c
class Solution
{
public:
    vector<int> printMatrix(vector<vector<int>> matrix)
    {
        vector<int> res;
        if (matrix.size() == 0)
            return res;
        int r1 = 0, r2 = matrix.size() - 1;
        int c1 = 0, c2 = matrix[0].size() - 1;
        int i = 0, j = 0;
        int sum = matrix.size() * matrix[0].size();
        while (res.size() < sum)
        {
            if (j == c1 && i == r1)
            {
                while (j <= c2)
                    res.push_back(matrix[i][j++]);
                ++r1;
                --j;
                ++i;
            }
            else if (j == c2 && i == r1)
            {
                while (i <= r2)
                    res.push_back(matrix[i++][j]);
                ++c2;
                --i;
                --j;
            }
            else if (j == c2 && i == r2)
            {
                while (j >= c1)
                    res.push_back(matrix[i][j--]);
                --r2;
                ++j;
                --i;
            }
            else
            {
                while (i >= r1)
                    res.push_back(matrix[i--][j]);
                ++c1;
                ++i;
                ++j;
            }
        }
        return res;
    }
};
```
## 选项


### A

```c
class Solution
{
public:
    vector<int> spiralOrder(vector<vector<int>> &matrix)
    {
        vector<int> res;
        int hor_top = 0;
        int hor_bottom = matrix.size() - 1;
        int ver_left = 0;
        int ver_right = matrix[0].size() - 1;
        int direction = 0;
        while (hor_top <= hor_bottom && ver_left <= ver_right)
        {
            switch (direction)
            {
            case 0:
                for (int i = ver_left; i <= ver_right; i++)
                {
                    res.push_back(matrix[hor_top][i]);
                }
                hor_top++;
                break;
            case 1:
                for (int i = hor_top; i <= hor_bottom; i++)
                {
                    res.push_back(matrix[i][ver_right]);
                }
                ver_right--;
                break;
            case 2:
                for (int i = ver_right; i >= ver_left; i--)
                {
                    res.push_back(matrix[hor_bottom][i]);
                }
                hor_bottom--;
                break;
            case 3:
                for (int i = hor_bottom; i >= hor_top; i--)
                {
                    res.push_back(matrix[i][ver_left]);
                }
                ver_left++;
                break;
            default:
                break;
            }
            direction++;
            direction %= 4;
        }
        return res;
    }
};
```

### B

```c
class Solution
{
public:
    vector<int> spiralOrder(vector<vector<int>> &matrix)
    {
        vector<int> res;
        if (matrix.size() == 0)
            return res;
        int up = 0, down = matrix.size() - 1, left = 0, right = matrix[0].size() - 1;
        while (up <= down && left <= right)
        {
            for (int i = left; i <= right; i++)
                res.push_back(matrix[up][i]);
            for (int i = up + 1; i <= down; i++)
                res.push_back(matrix[i][right]);
            if (up < down && left < right)
            {
                for (int i = right - 1; i > left; i--)
                    res.push_back(matrix[down][i]);
                for (int i = down; i > up; i--)
                    res.push_back(matrix[i][left]);
            }
            up++;
            down--;
            left++;
            right--;
        }
        return res;
    }
};
```

### C

```c
class Solution
{
public:
    vector<int> spiralOrder(vector<vector<int>> &matrix)
    {
        vector<int> path;
        if (matrix.empty())
            return path;
        int rows = matrix.size(), cols = matrix[0].size();
        int top = 0, bottom = rows - 1, left = 0, right = cols - 1;
        while (true)
        {
            for (int col = left; col <= right; ++col)
                path.push_back(matrix[top][col]);
            ++top;
            if (top > bottom)
                break;

            for (int row = top; row <= bottom; ++row)
                path.push_back(matrix[row][right]);
            --right;
            if (right < left)
                break;

            for (int col = right; col >= left; --col)
                path.push_back(matrix[bottom][col]);
            --bottom;
            if (top > bottom)
                break;

            for (int row = bottom; row >= top; --row)
                path.push_back(matrix[row][left]);
            ++left;
            if (right < left)
                break;
        }
        return path;
    }
};
```
