# 逆波兰表达式

正常的表达式称为中缀表达式，运算符在中间，主要是给人阅读的，机器求解并不方便。  

例如：3 + 5 * (2 + 6) - 1  

而且，常常需要用括号来改变运算次序。  

相反，如果使用逆波兰表达式（前缀表达式）表示，上面的算式则表示为：  

```
- + 3 * 5 + 2 6 1
```

不再需要括号，机器可以用递归的方法很方便地求解。

为了简便，我们假设：

1. 只有 $ + - * $ 三种运算符

2. 每个运算数都是一个小于10的非负整数  

下面的程序对一个逆波兰表示串进行求值。  

其返回值为一个数组：其中第一元素表示求值结果，第二个元素表示它已解析的字符数。 

请你补全代码：

```c
#include <bits/stdc++.h>
using namespace std;

struct EV
{
    int result;
    int n;
};

struct EV evaluate(char *x)
{
    struct EV ev = {0, 0};
    struct EV v1;
    struct EV v2;

    if (*x == 0)
        return ev;

    if (x[0] >= '0' && x[0] <= '9')
    {
        ev.result = x[0] - '0';
        ev.n = 1;
        return ev;
    }

    v1 = evaluate(x + 1);
    __________________

    if (x[0] == '+')
        ev.result = v1.result + v2.result;
    if (x[0] == '*')
        ev.result = v1.result * v2.result;
    if (x[0] == '-')
        ev.result = v1.result - v2.result;
    ev.n = 1 + v1.n + v2.n;

    return ev;
}

int main(int argc, char **argv)
{
    string str = "-+3*5+261";
    const EV &ev = evaluate((char *)(str.c_str()));
    cout << ev.result << endl;
    return 0;
}
```

## aop

### before

```c

```

### after

```c

```

## 答案

```c
v2 = evaluate(x + v1.n + 1);
```

## 选项

### A

```c
v2 = evaluate(x + v1.n);
```

### B

```c
v2 = evaluate(v1.n);
```

### C

```c
v2 = evaluate(v1.n + 1);
```
