# 第几个幸运数
到x星球旅行的游客都被发给一个整数，作为游客编号。  
x星的国王有个怪癖，他只喜欢数字3,5和7。  
国王规定，游客的编号如果只含有因子：3,5,7,就可以获得一份奖品。  

我们来看前10个幸运数字是：  
3 5 7 9 15 21 25 27 35 45  
因而第11个幸运数字是：49  

小明领到了一个幸运数字 59084709587505，他去领奖的时候，人家要求他准确地说出这是第几个幸运数字，否则领不到奖品。

请你帮小明计算一下，59084709587505是第几个幸运数字。



## aop
### before
```cpp
#include <iostream>
#include <cmath>
#include <queue>
#include <set>
using namespace std;
```
### after
```cpp

```

## 答案
```cpp
int main()
{
    set<long long> st;
    priority_queue<long long, vector<long long>, greater<long long>> pq;
    const int ok[3] = {3, 5, 7};
    st.insert(1);
    pq.push(1);
    int times = 0;
    while (true)
    {
        long long lucky = pq.top();
        pq.pop();
        if (lucky == 59084709587505)
        { //49
            cout << times << endl;
            return 0;
        }
        times++;
        for (int i = 0; i < 3; i++)
        {
            long long b = lucky * ok[i];
            if (!st.count(b))
            {
                st.insert(b);
                pq.push(b);
            }
        }
    }
    return 0;
}
```
## 选项

### A
```cpp
int main()
{
    set<long long> st;
    priority_queue<long long, vector<long long>, greater<long long>> pq;
    const int ok[3] = {3, 5, 7};
    st.insert(1);
    pq.push(1);
    int times = 0;
    while (true)
    {
        long long lucky = pq.top();
        pq.pop();
        if (lucky == 59084709587505)
        { //49
            cout << times << endl;
            return 0;
        }
        times++;
        for (int i = 0; i < 3; i++)
        {
            long long b = lucky * ok[i + 1];
            if (!st.count(b))
            {
                st.insert(b);
                pq.push(b);
            }
        }
    }
    return 0;
}
```

### B
```cpp
int main()
{
    set<long long> st;
    priority_queue<long long, vector<long long>, greater<long long>> pq;
    const int ok[3] = {3, 5, 7};
    st.insert(1);
    pq.push(1);
    int times = 0;
    while (true)
    {
        long long lucky = pq.top();
        pq.pop();
        if (lucky == 59084709587505)
        { //49
            cout << times << endl;
            return 0;
        }
        times++;
        for (int i = 0; i < 3; i++)
        {
            long long b = lucky * ok[i] + 1;
            if (!st.count(b))
            {
                st.insert(b);
                pq.push(b);
            }
        }
    }
    return 0;
}

```

### C
```cpp
int main()
{
    set<long long> st;
    priority_queue<long long, vector<long long>, greater<long long>> pq;
    const int ok[3] = {3, 5, 7};
    st.insert(1);
    pq.push(1);
    int times = 0;
    while (true)
    {
        long long lucky = pq.top();
        pq.pop();
        if (lucky == 59084709587505)
        { //49
            cout << times << endl;
            return 0;
        }
        times++;
        for (int i = 0; i < 3; i++)
        {
            long long b = lucky + ok[i];
            if (!st.count(b))
            {
                st.insert(b);
                pq.push(b);
            }
        }
    }
    return 0;
}

```
