#include <iostream>
#include <cstdio>
#include <map>
#include <cmath>
using namespace std;

int N;
map<int, int> cache; //int和int映射，哈希表用于缓存数值
int main()
{
    scanf("%d", &N);
    for (int c = 0; c * c <= N / 2; c++)
    {
        for (int d = c; c * c + d * d <= N; d++)
        {
            if (cache.find(c * c + d * d) == cache.end()) //如果未找到，再去存，已经存在就不需要去存了
                cache[c * c + d * d] = c;                 //查平方数，先要看cache里面有没有，没有说明它不是一个平方数存起来
            //有的话通过较小的数映射找到它
        }
    }
    //c*c+d*d要比a*a+d*d要大（至少相同）
    for (int a = 0; a * a <= N / 4; a++)
    { //单独看a*a小于等于N/4
        for (int b = a; a * a + b * b <= N / 2; b++)
        { //a*a+b*b小于等于N/2
            if (cache.find(N - a * a - b * b) != cache.end())
            {                                                 //查表，能找到
                int c = cache[N - a * a - b * b];             //c就可以知道
                int d = int(sqrt(N - a * a - b * b - c * c)); //d开方
                printf("%d %d %d %d\n", a, b, c, d);
                return 0; //跳出整个主函数
            }
        }
    }
    return 0;
}
//整个过程不需要再排序，因为一开始在写代码时，就已经限定了顺序大小，c*c+d*d要比a*a+d*d要大
