# 分配口罩
某市市长获得了若干批口罩，给定每批口罩的数量，市长要把口罩分配给市内的2所医院。

```
masks = [9090400, 8499400, 5926800, 8547000, 4958200, 4422600, 5751200, 4175600, 6309600, 5865200, 6604400, 4635000, 10663400, 8087200, 4554000]
```
由于物流限制，每一批口罩只能全部分配给其中一家医院。

市长希望2所医院获得的口罩总数之差越小越好。

请你计算这个差最小是多少？


## aop
### before
```cpp
#include <iostream>
#include <algorithm>
#include <cmath>
using namespace std;
long int masks[15] = {9090400, 8499400, 5926800, 8547000, 4958200,
                      4422600, 5751200, 4175600, 6309600,
                      5865200, 6604400, 4635000, 10663400, 8087200, 4554000};

long ans = 1000000000;
```
### after
```cpp
int main()
{
    dfs(0, 0, 0);
    cout << ans;
}

```

## 答案
```cpp
void dfs(int n, long h1, long h2)
{
    if (n == 15)
    {
        ans = min(ans, abs(h1 - h2));
        return;
    }
    dfs(n + 1, h1 + masks[n], h2);
    dfs(n + 1, h1, h2 + masks[n]);
}

```
## 选项

### A
```cpp
void dfs(int n, long h1, long h2)
{
    if (n == 15)
    {
        ans = min(ans, abs(h1 - h2));
        return;
    }
    dfs(n + 1, h1 + masks[n + 1], h2);
    dfs(n + 1, h1, h2 + masks[n + 1]);
}
```

### B
```cpp
void dfs(int n, long h1, long h2)
{
    if (n == 15)
    {
        ans = min(ans, abs(h1 - h2));
        return;
    }
    dfs(n + 1, h1 + masks[n + 1], h2);
    dfs(n + 1, h1, h2 + masks[n]);
}
```

### C
```cpp
void dfs(int n, long h1, long h2)
{
    if (n == 15)
    {
        ans = min(ans, abs(h1 - h2));
        return;
    }
    dfs(n, h1 + masks[n], h2);
    dfs(n, h1, h2 + masks[n]);
}
```
