# 合并区间

<p>以数组 <code>intervals</code> 表示若干个区间的集合，其中单个区间为 <code>intervals[i] = [start<sub>i</sub>, end<sub>i</sub>]</code> 。请你合并所有重叠的区间，并返回一个不重叠的区间数组，该数组需恰好覆盖输入中的所有区间。</p><p> </p><p><strong>示例 1：</strong></p><pre><strong>输入：</strong>intervals = [[1,3],[2,6],[8,10],[15,18]]<strong><br />输出：</strong>[[1,6],[8,10],[15,18]]<strong><br />解释：</strong>区间 [1,3] 和 [2,6] 重叠, 将它们合并为 [1,6].</pre><p><strong>示例 2：</strong></p><pre><strong>输入：</strong>intervals = [[1,4],[4,5]]<strong><br />输出：</strong>[[1,5]]<strong><br />解释：</strong>区间 [1,4] 和 [4,5] 可被视为重叠区间。</pre><p> </p><p><strong>提示：</strong></p><ul>	<li><code>1 <= intervals.length <= 10<sup>4</sup></code></li>	<li><code>intervals[i].length == 2</code></li>	<li><code>0 <= start<sub>i</sub> <= end<sub>i</sub> <= 10<sup>4</sup></code></li></ul>
<p>以下<font color="red">错误</font>的选项是？</p>

## aop

### before

```cpp
#include <bits/stdc++.h>
using namespace std;
```
### after

```cpp

```

## 答案

```cpp
class Solution
{
public:
    vector<vector<int>> merge(vector<vector<int>> &intervals)
    {
        vector<vector<int>> res;
        sort(intervals.begin(), intervals.end(), [](const auto &u, const auto &v)
             {
                 if (u[0] == v[0])
                     return u[1] > v[1];
                 else
                     return u[0] < v[0];
             });
        auto it = intervals.begin();
        int first = (*it)[0], second = (*it)[1];
        for (it++; it != intervals.end(); it++)
        {
            if ((*it)[0] <= second)
                second = max(second, (*it)[0]);
            else
            {
                res.push_back({first, second});
                first = (*it)[0];
                second = (*it)[1];
            }
        }
        res.push_back({first, second});
        return res;
    }
};
```
## 选项


### A

```cpp
class Solution
{
public:
    vector<vector<int>> merge(vector<vector<int>> &intervals)
    {
        vector<vector<int>> res;
        sort(intervals.begin(), intervals.end());
        for (auto it = intervals.begin(); it != intervals.end(); it++)
        {
            int first = (*it)[0], second = (*it)[1];
            if (!res.size() || res.back()[1] < first)
                res.push_back({first, second});
            else
                res.back()[1] = max(res.back()[1], second);
        }
        return res;
    }
};
```

### B

```cpp
class Solution
{
public:
    vector<vector<int>> merge(vector<vector<int>> &intervals)
    {
        sort(intervals.begin(), intervals.end());
        vector<vector<int>> res;
        for (int i = 0; i < intervals.size();)
        {
            int t = intervals[i][1];
            int j = i + 1;
            while (j < intervals.size() && intervals[j][0] <= t)
            {
                t = max(t, intervals[j][1]);
                j++;
            }
            res.push_back({intervals[i][0], t});
            i = j;
        }
        return res;
    }
};
```

### C

```cpp
class Solution
{
public:
    static bool cmp(const vector<int> &a, const vector<int> &b)
    {
        if (a[0] == b[0])
            return a[1] > b[1];
        return a[0] < b[0];
    }
    vector<vector<int>> merge(vector<vector<int>> &intervals)
    {
        if (intervals.empty())
            return intervals;
        vector<vector<int>> res;
        int count = 0;
        sort(intervals.begin(), intervals.end(), cmp);
        vector<int> temp;
        temp.push_back(intervals[0][0]);
        temp.push_back(intervals[0][1]);
        res.push_back(temp);
        for (int i = 1; i < intervals.size(); i++)
        {
            if (res[count][1] >= intervals[i][0])
            {
                if (res[count][1] <= intervals[i][1])
                {
                    res[count][1] = intervals[i][1];
                }
            }
            else
            {
                count++;
                temp[0] = intervals[i][0];
                temp[1] = intervals[i][1];
                res.push_back(temp);
            }
        }
        return res;
    }
};
```
