# 9数算式

观察如下的算式：
```
9213 x 85674 = 789314562
```
左边的乘数和被乘数正好用到了1~9的所有数字，每个1次。
而乘积恰好也是用到了1~9的所有数字，并且每个1次。

请你借助计算机的强大计算能力，找出满足如上要求的9数算式一共有多少个？

注意：

1. 总数目包含题目给出的那个示例。
2. 乘数和被乘数交换后作为同一方案来看待。

以下<font color="red">错误</font>的是？

## aop

### before

```cpp
#include <bits/stdc++.h>
using namespace std;
```
### after

```cpp

```

## 答案

```cpp
int bei[10];
map<long long, int> mp;

int main()
{
    int a[9] = {1, 2, 3, 4, 5, 6, 7, 8, 9};
    int res = 0;
    while (next_permutation(a, a + 9))
    {
        for (int i = 1; i < 9; i++)
        {
            memset(bei, 0, sizeof(bei));
            long long int ans, left = 0, right = 0, t = 0, x = 0, y = 0;
            for (int j = 0; j <= i; j++)
            {
                left = left * 10 + a[j];
            }
            x = left;
            x = x * 10;
            for (int k = i + 1; k < 9; k++)
            {
                right = right * 10 + a[k];
            }
            y = right;
            y = y * 10;
            for (int j = 0; j <= i; j++)
                y = y * 10 + a[j];

            ans = left * right;
            long long int ff = ans;
            while (ans >= 0)
            {
                int x = ans % 10;
                ans = ans / 10;
                if (bei[x] == 0 && x != 0)
                {
                    bei[x] = 1;
                    t++;
                }
            }
            if (mp.count(x) == 0 && mp.count(y) == 0)
            {
                res++;
                mp[x] = 1;
                mp[y] = 1;
            }
        }
    };
    cout << res << endl;
    return 0;
}
```
## 选项


### A

```cpp
const int N = 1e3 + 5;
int a[15] = {9, 2, 1, 3, 8, 5, 6, 7, 4}, res = 0, vis[12], temp1;
bool fun(int x)
{
    int t1 = 0, t2 = 0;
    for (int i = x, j = 1; i >= 0; i--, j *= 10)
    {
        t1 = a[i] * j + t1;
    }
    for (int i = 8, j = 1; i > x; i--, j *= 10)
    {
        t2 = a[i] * j + t2;
    }

    temp1 = t1 * t2;
    int temp = temp1;
    memset(vis, 0, sizeof(vis));
    while (temp)
    {
        vis[temp % 10] = 1;
        temp /= 10;
    }
    for (int i = 1; i <= 9; i++)
    {
        if (!vis[i])
            return false;
    }
    return true;
}
int main()
{

    for (int i = 0; i < 9; i++)
        a[i] = i + 1;

    set<int> st;
    do
    {
        for (int i = 0; i < 8; i++)
        {
            if (fun(i))
            {
                st.insert(temp1);
                res++;
            }
        }
    } while (next_permutation(a, a + 9));
    cout << res / 2 << '\n';

    return 0;
}
```

### B

```cpp
int st[10], res[10], book[10], cnt;

int cal(int l, int r)
{
    int t = 0;
    for (int i = l; i <= r; i++)
    {
        t = t * 10 + res[i];
    }
    return t;
}

bool check(int k)
{
    for (int i = 0; i < 10; i++)
        book[i] = 0;
    while (k)
    {
        book[k % 10]++;
        k /= 10;
    }
    bool flag = true;
    for (int i = 1; i <= 9; i++)
    {
        if (book[i] != 1)
            flag = false;
    }
    return flag;
}

void dfs(int k)
{
    if (k == 9)
    {
        for (int i = 0; i < 8; i++)
        {
            int a = cal(0, i);
            int b = cal(i + 1, 8);
            if (check(a * b))
            {
                cnt++;
            }
        }
        return;
    }
    for (int i = 1; i <= 9; i++)
    {
        if (!st[i])
        {
            st[i] = 1;
            res[k] = i;
            dfs(k + 1);
            st[i] = 0;
        }
    }
}
int main()
{
    dfs(0);
    cout << cnt / 2;
    return 0;
}
```

### C

```cpp
typedef long long LL;
const int N = 15;
bool vis[N];
int ans;

bool check_2(LL sumb)
{
    bool st[N];
    for (int i = 1; i <= 9; i++)
    {
        st[i] = 0;
    }
    while (sumb)
    {
        st[sumb % 10] = true;
        sumb = sumb / 10;
    }
    bool flag = false;
    for (int i = 1; i <= 9; i++)
    {
        if (!st[i])
        {
            return false;
        }
    }
    return true;
}

bool check_1(int suma, int sumc)
{
    LL sumb = (LL)suma * sumc;
    if (check_2(sumb))
    {
        return true;
    }
    return false;
}

void dfs_c(int u, int suma, int sumc)
{
    if (u > 9)
    {
        return;
    }

    if (check_1(suma, sumc))
    {
        ans++;
        return;
    }

    for (int i = 1; i <= 9; i++)
    {
        if (!vis[i])
        {
            vis[i] = true;
            dfs_c(u + 1, suma, sumc * 10 + i);
            vis[i] = false;
        }
    }
}

void dfs_a(int u, int suma)
{
    dfs_c(u, suma, 0);

    for (int i = 1; i <= 9; i++)
    {
        if (!vis[i])
        {
            vis[i] = true;
            dfs_a(u + 1, suma * 10 + i);
            vis[i] = false;
        }
    }
}

int main()
{
    dfs_a(0, 0);
    cout << ans / 2 << endl;
    return 0;
}
```
