#include <iostream>
#include <cstring>
#include <algorithm>

using namespace std;

const int row = 3, col = 4;
int a[] = {0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1};
int map[row][col];
bool st[row][col];
int ans;

int dx[] = {-1, 0, 1, 0}, dy[] = {0, 1, 0, -1};

//连通 直接走完连通的部分
void dfs(int x, int y)
{
    st[x][y] = true;
    for (int i = 0; i < 4; i++)
    {
        int tx = x + dx[i], ty = y + dy[i];
        if (tx < 0 || tx >= row || ty < 0 || ty >= col)
            continue;
        if (st[tx][ty] || !map[tx][ty])
            continue;
        dfs(tx, ty);
    }
}

int main()
{
    do
    {
        //重置
        memset(map, 0, sizeof map), memset(st, false, sizeof st);
        int num = 0, cnt = 0;

        //读入
        for (int i = 0; i < row; i++)
            for (int j = 0; j < col; j++)
                map[i][j] = a[cnt++];

        //连通
        for (int i = 0; i < row; i++)
            for (int j = 0; j < col; j++)
                if (!st[i][j] && map[i][j])
                    num++, dfs(i, j);

        //检查 连通块只有一个，正确
        if (num == 1)
            ans++;
    } while (next_permutation(a, a + 12));

    cout << ans;

    return 0;
}
