# 两数相加
<p>给你两个 <strong>非空</strong> 的链表，表示两个非负的整数。它们每位数字都是按照 <strong>逆序</strong> 的方式存储的，并且每个节点只能存储 <strong>一位</strong> 数字。</p><p>请你将两个数相加，并以相同形式返回一个表示和的链表。</p><p>你可以假设除了数字 0 之外，这两个数都不会以 0 开头。</p><p> </p><p><strong>示例 1：</strong></p><img alt="" src="https://cdn.jsdelivr.net/gh/doocs/leetcode@main/solution/0000-0099/0002.Add%20Two%20Numbers/images/addtwonumber1.jpg" style="width: 483px; height: 342px;" /><pre><strong>输入：</strong>l1 = [2,4,3], l2 = [5,6,4]<strong><br />输出：</strong>[7,0,8]<strong><br />解释：</strong>342 + 465 = 807.</pre><p><strong>示例 2：</strong></p><pre><strong>输入：</strong>l1 = [0], l2 = [0]<strong><br />输出：</strong>[0]</pre><p><strong>示例 3：</strong></p><pre><strong>输入：</strong>l1 = [9,9,9,9,9,9,9], l2 = [9,9,9,9]<strong><br />输出：</strong>[8,9,9,9,0,0,0,1]</pre><p> </p><p><strong>提示：</strong></p><ul>	<li>每个链表中的节点数在范围 <code>[1, 100]</code> 内</li>	<li><code>0 <= Node.val <= 9</code></li>	<li>题目数据保证列表表示的数字不含前导零</li></ul>
<p>以下错误的选项是？</p>
## aop
### before
```cpp
#include <unordered_map>
#include <vector>
#include <iostream>
#include <map>
using namespace std;

struct ListNode
{
    int val;
    struct ListNode *next;
    ListNode() : val(0), next(nullptr){};
    ListNode(int x) : val(x), next(nullptr){};
    ListNode(int x, ListNode *next) : val(x), next(next){};
};
```
### after
```cpp

int main()
{
    Solution test;
    ListNode *L1 = new ListNode();
    ListNode *l11 = new ListNode(2);
    ListNode *l12 = new ListNode(4);
    ListNode *l13 = new ListNode(3);

    L1->next = l11;
    l11->next = l12;
    l12->next = l13;

    ListNode *L2 = new ListNode();
    ListNode *l21 = new ListNode(5);
    ListNode *l22 = new ListNode(6);
    ListNode *l23 = new ListNode(4);

    L2->next = l21;
    l21->next = l22;
    l22->next = l23;

    ListNode *ret = new ListNode();

    ret = test.addTwoNumbers(L1, L2);

    ListNode *p = ret->next;

    while (p != NULL)
    {
        cout << p->val << endl;
        p = p->next;
    }

    return 0;
}
```

## 答案
```cpp
class Solution
{
public:
    ListNode *addTwoNumbers(ListNode *l1, ListNode *l2)
    {
        ListNode *l3 = new ListNode(0);
        ListNode *p1 = l1;
        ListNode *p2 = l2;
        ListNode *p3 = l3;

        int sum = 0, carry = 0;
        while (p1 != NULL || p2 != NULL)
        {
            int x = (p1 != NULL) ? p1->val : 0;
            int y = (p2 != NULL) ? p2->val : 0;
            sum = x + y + carry;
            carry = sum / 10;
            p3->next = new ListNode(sum % 10);
            p3 = p3->next;
            if (p1 != NULL)
            {
                p1 = p1->next;
            }
            if (p2 != NULL)
            {
                p2 = p2->next;
            }
        }
        if (carry == 0)
        {
            p3->next = new ListNode(carry);
            p3 = p3->next;
        }
        return l3->next;
    }
};
```
## 选项

### A
```cpp
class Solution
{
public:
    ListNode *addTwoNumbers(ListNode *l1, ListNode *l2)
    {
        ListNode *retList = new ListNode(0);
        auto tempList = retList;
        int newVal;
        int val1;
        int val2;
        int carryBit = 0;
        while (l1 != nullptr || l2 != nullptr)
        {
            if (l1 == nullptr)
                val1 = 0;
            else
            {
                val1 = l1->val;
                l1 = l1->next;
            }
            if (l2 == nullptr)
                val2 = 0;
            else
            {
                val2 = l2->val;
                l2 = l2->next;
            }
            newVal = (val1 + val2 + carryBit) % 10;
            carryBit = (val1 + val2 + carryBit) / 10;
            tempList->next = new ListNode(newVal);
            tempList = tempList->next;
        }

        if (carryBit == 1)
        {
            tempList->next = new ListNode(1);
        }
        return retList->next;
    }
};
```

### B
```cpp
class Solution
{
public:
    ListNode *addTwoNumbers(ListNode *l1, ListNode *l2)
    {
        ListNode *l3 = new ListNode;
        ListNode *l4 = l3;
        int m = 0;
        while (l1 != nullptr || l2 != nullptr)
        {
            if (l1 != nullptr && l2 != nullptr)
            {
                l3->val = (l1->val + l2->val + m) % 10;
                m = (l1->val + l2->val + m) / 10;
                l1 = l1->next;
                l2 = l2->next;
            }
            else if (l1 != nullptr)
            {
                l3->val = (l1->val + m) % 10;
                m = (l1->val + m) / 10;
                l1 = l1->next;
            }
            else if (l2 != nullptr)
            {
                l3->val = (l2->val + m) % 10;
                m = (l2->val + m) / 10;

                l2 = l2->next;
            }

            if (l1 != nullptr || l2 != nullptr)
            {
                l3->next = new ListNode;
                l3 = l3->next;
            }
            else
            {
                if (m > 0)
                {
                    l3->next = new ListNode(m);
                }
            }
        }

        return l4;
    }
};
```

### C
```cpp
class Solution
{
public:
    ListNode *addTwoNumbers(ListNode *l1, ListNode *l2)
    {
        ListNode *head = new ListNode(0), *r = head;
        int up = 0;
        while (l1 != NULL || l2 != NULL || up)
        {
            r->next = new ListNode(((l1 == NULL ? 0 : l1->val) + (l2 == NULL ? 0 : l2->val) + up) % 10);
            up = ((l1 == NULL ? 0 : l1->val) + (l2 == NULL ? 0 : l2->val) + up) / 10;
            r = r->next;
            if (l1 != NULL)
                l1 = l1->next;
            if (l2 != NULL)
                l2 = l2->next;
        }
        return head->next;
    }
};
```
