# 凑算式

```
　　 B 　　 DEF   
A + —- +  ——–- = 10   
　　 C 　　 GHI  
```
这个算式中A~I代表1~9的数字，不同的字母代表不同的数字。  

比如：   
6+8/3+952/714 就是一种解法，   
5+3/1+972/486 是另一种解法。  

这个算式一共有多少种解法？  
 

## aop

### before

```cpp
#include <stdio.h>
#include <stdbool.h>

int ans = 0;
int nums[10];
bool visited[10];

void judge()
{
	int i;
	if (nums[0] + (double)nums[1] / nums[2] + (double)(nums[3] * 100 + nums[4] * 10 + nums[5]) / (nums[6] * 100 + nums[7] * 10 + nums[8]) == 10)
	{
		printf("%d + %d/%d + %d%d%d/%d%d%d", nums[0], nums[1], nums[2], nums[3], nums[4], nums[5], nums[6], nums[7], nums[8]);
		printf("\n");
		ans++;
	}
}
```

### after

```cpp
int main()
{
	dfs(0);
	printf("%d\n", ans);
	return 0;
}

```

## 答案

```cpp
void dfs(int index)
{
	if (index >= 9)
	{
		judge();
		return;
	}
	int i;
	for (i = 1; i < 10; i++)
	{
		if (visited[i] == false)
		{
			visited[i] = true;
			nums[index] = i;
			dfs(index + 1);
			visited[i] = false;
		}
	}
}
```
## 选项


### A

```cpp
void dfs(int index)
{
	if (index >= 9)
	{
		judge();
		return;
	}
	int i;
	for (i = 1; i < 10; i++)
	{
		if (visited[i] == false)
		{
			visited[i] = true;
			nums[index] = i;
			dfs(index);
			visited[i] = false;
		}
	}
}
```

### B

```cpp
void dfs(int index)
{
	if (index >= 9)
	{
		judge();
		return;
	}
	int i;
	for (i = 1; i < 10; i++)
	{
		if (visited[i] == true)
		{
			visited[i] = false;
			nums[index] = i;
			dfs(index);
			visited[i] = true;
		}
	}
}
```

### C

```cpp
void dfs(int index)
{
	if (index >= 9)
	{
		judge();
		return;
	}
	int i;
	for (i = 1; i < 10; i++)
	{
		if (visited[i] == true)
		{
			visited[i] = false;
			nums[index] = i;
			dfs(index + 1);
			visited[i] = true;
		}
	}
}
```
