# 带分数

**问题描述**

100 可以表示为带分数的形式：100 = 3 + 69258 / 714。

还可以表示为：100 = 82 + 3546 / 197。

注意特征：带分数中，数字1~9分别出现且只出现一次（不包含0）。

类似这样的带分数，100 有 11 种表示法。

**输入格式**

从标准输入读入一个正整数N (N<1000*1000)

**输出格式**

程序输出该数字用数码1~9不重复不遗漏地组成带分数表示的全部种数。

注意：不要求输出每个表示，只统计有多少表示法！

**样例输入1**

```
100
```
**样例输出1**

```
11
```
**样例输入2**

```
105
```
**样例输出2**

```
6
```

## aop

### before

```cpp
#include <stdio.h>
int x = 0, number = 0, count = 0;

void Swap(int &a, int &b)
{
    int temp = a;
    a = b;
    b = temp;
}

int getNum(int list[], int f, int r)
{
    int i = 0, num = 0;
    for (i = f; i <= r; i++)
        num = list[i] + num * 10;
    return num;
}

```
### after

```cpp
int main()
{
    int temp = 0;
    int list[] = {1, 2, 3, 4, 5, 6, 7, 8, 9};
    scanf("%d", &number);
    temp = number;
    while (temp != 0)
    {
        ++x;
        temp /= 10;
    }
    Prim(list, 0, 9);
    printf("%d", count);
    return 0;
}
```

## 答案

```cpp
void Prim(int list[], int k, int m)
{
    if (k == m - 1)
    {
        int a = 0, b = 0, c = 0, bLast = 0;
        for (int i = 0; i < x; i++)
        {
            a = getNum(list, 0, i);
            bLast = ((number - a) * list[8]) % 10;
            for (int j = i + (8 - i) / 2; j < 8; j++)
            {
                if (list[j] == bLast)
                {
                    b = getNum(list, i + 1, j);
                    c = getNum(list, j + 1, 8);
                    if (b % c == 0 && a + b / c == number)
                    {

                        ++count;
                    }
                    break;
                }
            }
        }
    }
    else
    {
        for (int i = k; i < m; i++)
        {

            Swap(list[k], list[i]);
            Prim(list, k + 1, m);

            Swap(list[k], list[i]);
        }
    }
}
```
## 选项


### A

```cpp
void Prim(int list[], int k, int m)
{
    if (k == m - 1)
    {
        int a = 0, b = 0, c = 0, bLast = 0;
        for (int i = 0; i < x; i++)
        {
            a = getNum(list, 0, i);
            bLast = ((number - a) * list[8]) % 10;
            for (int j = i + (8 - i) / 2; j < 8; j++)
            {
                if (list[j] == bLast)
                {
                    b = getNum(list, i, j);
                    c = getNum(list, j, 8);
                    if (b % c == 0 && a + b / c == number)
                    {

                        ++count;
                    }
                    break;
                }
            }
        }
    }
    else
    {
        for (int i = k; i < m; i++)
        {

            Swap(list[k], list[i]);
            Prim(list, k + 1, m);

            Swap(list[k], list[i]);
        }
    }
}
```

### B

```cpp
void Prim(int list[], int k, int m)
{
    if (k == m - 1)
    {
        int a = 0, b = 0, c = 0, bLast = 0;
        for (int i = 0; i < x; i++)
        {
            a = getNum(list, 0, i);
            bLast = ((number - a) * list[8]) % 10;
            for (int j = i + (8 - i) / 2; j < 8; j++)
            {

                b = getNum(list, i, j);
                c = getNum(list, j, 8);
                if (b % c == 0 && a + b / c == number)
                {

                    ++count;
                }
                break;
            }
        }
    }
    else
    {
        for (int i = k; i < m; i++)
        {

            Swap(list[k], list[i]);
            Prim(list, k + 1, m);

            Swap(list[k], list[i]);
        }
    }
}
```

### C

```cpp
void Prim(int list[], int k, int m)
{
    if (k == m - 1)
    {
        int a = 0, b = 0, c = 0, bLast = 0;
        for (int i = 0; i < x; i++)
        {
            a = getNum(list, 0, i);
            bLast = ((number - a) * list[8]) % 10;
            for (int j = i + (8 - i) / 2; j < 8; j++)
            {
                if (list[j] == bLast)
                {
                    b = getNum(list, i + 1, j);
                    c = getNum(list, j + 1, 8);
                    ++count;
                    break;
                }
            }
        }
    }
    else
    {
        for (int i = k; i < m; i++)
        {

            Swap(list[k], list[i]);
            Prim(list, k + 1, m);

            Swap(list[k], list[i]);
        }
    }
}
```
