# 倍数问题

**题目描述**

众所周知，小葱同学擅长计算，尤其擅长计算一个数是否是另外一个数的倍数。但小葱只擅长两个数的情况，当有很多个数之后就会比较苦恼。现在小葱给了你 n 个数，希望你从这 n 个数中找到三个数，使得这三个数的和是 K 的倍数，且这个和最大。数据保证一定有解。

**输入格式**

从标准输入读入数据。
第一行包括 2 个正整数 n, K。
第二行 n 个正整数，代表给定的 n 个数。

**输出格式**

输出到标准输出。
输出一行一个整数代表所求的和。

**样例输入**

```
4 3
1 2 3 4
```

**样例输出**

```
9
```

**样例解释**

```
选择2、3、4。
```

## aop

### before

```cpp
#include <bits/stdc++.h>
#include <string>
#include <queue>
#include <set>
#include <cstring>
#include <cmath>
#include <algorithm>
#define MAX 1000000000
using namespace std;
int n, k, a[100010];
int b[4];
int flag = 0;
```
### after

```cpp
int main()
{
	cin >> n >> k;
	a[0] = MAX;
	for (int i = 1; i <= n; i++)
		cin >> a[i];
	sort(a + 1, a + n + 1);
	reverse(a + 1, a + n + 1);
	dfs(a, n, 1);
	return 0;
}
```

## 答案

```cpp
void dfs(int a[], int n, int s)
{
	if (flag == 1)
		return;
	if (s == 4)
	{
		int sum = b[1] + b[2] + b[3];
		if (sum % k == 0)
		{
			flag = 1;
			cout << sum << endl;
		}
		return;
	}
	for (int i = 1; i <= n; i++)
	{
		if (a[i] < a[s - 1])
		{
			b[s] = a[i];
			dfs(a, n, s + 1);
		}
	}
}
```
## 选项


### A

```cpp
void dfs(int a[], int n, int s)
{
	if (flag == 1)
		return;
	if (s == 4)
	{
		int sum = b[1] + b[2] + b[3];
		if (sum % k == 0)
		{
			flag = 1;
			cout << sum << endl;
		}
		return;
	}
	for (int i = 1; i <= n; i++)
	{
		if (a[i] < a[s - 1])
		{
			b[s] = a[i];
			dfs(a, n, s);
		}
	}
}
```

### B

```cpp
void dfs(int a[], int n, int s)
{
	if (flag == 1)
		return;
	if (s == 4)
	{
		int sum = b[1] + b[2] + b[3];
		if (sum % k == 0)
		{
			flag = 1;
			cout << sum << endl;
		}
		return;
	}
	for (int i = 1; i <= n; i++)
	{
		if (a[i] < a[s + 1])
		{
			b[s] = a[i];
			dfs(a, n, s + 1);
		}
	}
}
```

### C

```cpp
void dfs(int a[], int n, int s)
{
	if (flag == 1)
		return;
	if (s == 4)
	{
		int sum = b[1] + b[2] + b[3];
		if (sum % k == 0)
		{
			flag = 1;
			cout << sum << endl;
		}
		return;
	}
	for (int i = 1; i <= n; i++)
	{
		if (a[i] < a[s + 1])
		{
			b[s] = a[i];
			dfs(a, n, s);
		}
	}
}
```
