# 等差素数列


2,3,5,7,11,13,....是素数序列。
类似：7,37,67,97,127,157 这样完全由素数组成的等差数列，叫等差素数数列。
上边的数列公差为30，长度为6。

2004年，格林与华人陶哲轩合作证明了：存在任意长度的素数等差数列。
这是数论领域一项惊人的成果！

有这一理论为基础，请你借助手中的计算机，满怀信心地搜索：

长度为10的等差素数列，其公差最小值是多少？


## aop

### before

```cpp
#include <cstdio>
#include <algorithm>
#include <set>
using namespace std;

typedef long long LL;
set<int> all;

bool isPrimt(LL t)
{ 
    for (int i = 2; i < t / 2; ++i)
    {
        if (t % i == 0)
            return false;
    }
    return true;
}
```
### after

```cpp
const int N = 5000;
int main()
{
    LL a[N];

    a[0] = 2;
    a[1] = 3;
    all.insert(2);
    all.insert(3);

    int index = 2;
    LL t = 5;
    while (index < N)
    { 
        if (isPrimt(t))
        {
            a[index++] = t;
            all.insert(t);
        }
        t++;
    }

    printf("%d\n", f(a, N));
    return 0;
}
```

## 答案

```cpp
int f(LL a[], int n)
{ 
    for (int i = 0; i < n; ++i)
    { 
        LL first = a[i];
        for (int delta = 1; delta < a[n - 1] - first; ++delta)
        { 
            int m = first;
            for (int j = 1; j < 10; ++j)
            { 
                m += delta;
                if (all.find(m) == all.end())
                    break; 
                if (m > a[n - 1])
                    break;
                if (j == 9) 
                    return delta;
            }
        }
    }
    return -1;
}
```
## 选项


### A

```cpp
int f(LL a[], int n)
{ 
    for (int i = 0; i < n; ++i)
    { 
        LL first = a[i];
        for (int delta = 1; delta < a[n] - first; ++delta)
        { 
            int m = first;
            for (int j = 1; j < 10; ++j)
            { 
                m += delta;
                if (all.find(m) == all.end())
                    break; 
                if (m > a[n - 1])
                    break;
                if (j == 9) 
                    return delta;
            }
        }
    }
    return -1;
}
```

### B

```cpp
int f(LL a[], int n)
{ 
    for (int i = 0; i < n; ++i)
    { 
        LL first = a[i];
        for (int delta = 1; delta < a[n + 1] - first; ++delta)
        { 
            int m = first;
            for (int j = 1; j < 10; ++j)
            { 
                m += delta;
                if (all.find(m) == all.end())
                    break; 
                if (m > a[n - 1])
                    break;
                if (j == 9) 
                    return delta;
            }
        }
    }
    return -1;
}
```

### C

```cpp
int f(LL a[], int n)
{ 
    for (int i = 0; i < n; ++i)
    { 
        LL first = a[i];
        for (int delta = 1; delta < a[n + 1] + first; ++delta)
        { 
            int m = first;
            for (int j = 1; j < 10; ++j)
            { 
                m += delta;
                if (all.find(m) == all.end())
                    break; 
                if (m > a[n - 1])
                    break;
                if (j == 9) 
                    return delta;
            }
        }
    }
    return -1;
}
```
