# 分数

1/1 + 1/2 + 1/4 + 1/8 + 1/16 + … 每项是前一项的一半，如果一共有20项，求这个和是多少，结果用分数表示出来。  
类似：3/2  
当然，这只是加了前2项而已。分子分母要求互质。  

## aop

### before

```cpp
#include <bits/stdc++.h>
using namespace std;
```
### after

```cpp
int gcd(long a, long b)
{
    if (b == 0)
        return a;
    return gcd(b, a % b);
}
int main()
{
    cout << gcd(pow_2(20) - 1, pow_2(19)) << endl;
    cout << pow_2(20) - 1 << "/" << pow_2(19) << endl;
}
```

## 答案

```cpp
long pow_2(int b)
{
    long x = 2;
    long res = 1;
    while (b > 0)
    {
        if (b & 1)
            res *= x;
        b >>= 1;
        x = x * x;
    }
    return res;
}
```
## 选项


### A

```cpp
long pow_2(int b)
{
    long x = 2;
    long res = 1;
    while (b > 0)
    {
        if (b & 1)
            res *= x;
        b <<= 1;
        x = x * x;
    }
    return res;
}
```

### B

```cpp
long pow_2(int b)
{
    long x = 2;
    long res = 1;
    while (b > 0)
    {
        if (b && 1)
            res *= x;
        b <<= 1;
        x = x * x;
    }
    return res;
}
```

### C

```cpp
long pow_2(int b)
{
    long x = 2;
    long res = 1;
    while (b > 0)
    {
        if (b & 1)
            res = x;
        b >>= 1;
        x = x * x;
    }
    return res;
}
```
