#include <bits/stdc++.h>
using namespace std;

class Twitter
{
public:
    /** Initialize your data structure here. */
    Twitter()
    {
    }

    /** Compose a new tweet. */
    void postTweet(int userId, int tweetId)
    {
        context.push_back(make_pair(userId, tweetId));
    }

    /** Retrieve the 10 most recent tweet ids in the user's news feed. Each item in the news feed must be posted by users who the user followed or by the user herself. Tweets must be ordered from most recent to least recent. */
    vector<int> getNewsFeed(int userId)
    {
        int n = context.size();
        int count = 0;
        vector<int> res;
        int k = n - 1;
        while (count < 10 && k >= 0)
        {
            auto it = context[k];
            if (it.first == userId || tmp[make_pair(userId, it.first)])
            {
                res.push_back(context[k].second);
                count++;
            }
            k--;
        }
        return res;
    }

    /** Follower follows a followee. If the operation is invalid, it should be a no-op. */
    void follow(int followerId, int followeeId)
    {
        tmp[make_pair(followerId, followeeId)] = 1;
    }

    /** Follower unfollows a followee. If the operation is invalid, it should be a no-op. */
    void unfollow(int followerId, int followeeId)
    {
        tmp[make_pair(followerId, followeeId)] = 0;
    }

private:
    map<pair<int, int>, int> tmp;
    vector<pair<int, int>> context;
};

/**
 * Your Twitter object will be instantiated and called as such:
 * Twitter* obj = new Twitter();
 * obj->postTweet(userId,tweetId);
 * vector<int> param_2 = obj->getNewsFeed(userId);
 * obj->follow(followerId,followeeId);
 * obj->unfollow(followerId,followeeId);
 */
