# 电话号码的字母组合

<p>给定一个仅包含数字 <code>2-9</code> 的字符串，返回所有它能表示的字母组合。答案可以按 <strong>任意顺序</strong> 返回。</p><p>给出数字到字母的映射如下（与电话按键相同）。注意 1 不对应任何字母。</p><p><img src="https://img-blog.csdnimg.cn/img_convert/71e2c27cd43a6f678c1972f865e982d0.png#pic_center" /></p><p><strong>示例 1：</strong></p><pre><strong>输入：</strong>digits = "23"<strong><br />输出：</strong>["ad","ae","af","bd","be","bf","cd","ce","cf"]</pre><p><strong>示例 2：</strong></p><pre><strong>输入：</strong>digits = ""<strong><br />输出：</strong>[]</pre><p><strong>示例 3：</strong></p><pre><strong>输入：</strong>digits = "2"<strong><br />输出：</strong>["a","b","c"]</pre><p><strong>提示：</strong></p><ul>	<li><code>0 <= digits.length <= 4</code></li>	<li><code>digits[i]</code> 是范围 <code>['2', '9']</code> 的一个数字。</li></ul>
<p>以下<span style="color:red">错误</span>的选项是？</p>

## aop

### before

```c
#include <bits/stdc++.h>
using namespace std;
```

### after

```c
int main()
{
    Solution sol;
    string digits = "23";
    vector<string> res;
    res = sol.letterCombinations(digits);
    for (auto i : res)
        cout << i + ' ';
    return 0;
}
```

## 答案

```c
string letterMap[10] = {" ", " ", "abc", "def", "ghi", "jkl", "mno", "pqrs", "tuv", "wxyz"};
class Solution
{
public:
    void combinStr(const string &digits, size_t index, const string &str, vector<string> &strs)
    {
        if (index == digits.size())
        {
            strs.push_back(str);
            return;
        }
        string letters = letterMap[digits[index] - '0'];
        for (size_t i = 0; i < letters.size(); i++)
        {
            combinStr(digits, index, str + letters[i], strs);
        }
    }
    vector<string> letterCombinations(string digits)
    {
        vector<string> strs;
        if (digits.empty())
            return strs;
        size_t index = 0;
        string str;

        combinStr(digits, index, str, strs);
        return strs;
    }
};
```
## 选项


### A

```c
class Solution
{
public:
    vector<string> result;
    vector<string> letterCombinations(string digits)
    {
        string temp;
        if (digits.length() == 0)
            return result;
        getAns(digits, 0, temp, result);
        return result;
    }
    void getAns(string digits, int start, string temp, vector<string> &result)
    {
        if (temp.size() == digits.length())
            result.push_back(temp);
        else
        {
            vector<char> let = getLet(digits[start]);
            for (int i = 0; i < let.size(); i++)
            {
                temp.append(1, let[i]);
                getAns(digits, start + 1, temp, result);
                temp.pop_back();
            }
        }
    }
    vector<char> getLet(char i)
    {
        vector<char> let;
        if (i == '2')
        {
            let.push_back('a');
            let.push_back('b');
            let.push_back('c');
        }
        else if (i == '3')
        {
            let.push_back('d');
            let.push_back('e');
            let.push_back('f');
        }
        else if (i == '4')
        {
            let.push_back('g');
            let.push_back('h');
            let.push_back('i');
        }
        else if (i == '5')
        {
            let.push_back('j');
            let.push_back('k');
            let.push_back('l');
        }
        else if (i == '6')
        {
            let.push_back('m');
            let.push_back('n');
            let.push_back('o');
        }
        else if (i == '7')
        {
            let.push_back('p');
            let.push_back('q');
            let.push_back('r');
            let.push_back('s');
        }
        else if (i == '8')
        {
            let.push_back('t');
            let.push_back('u');
            let.push_back('v');
        }
        else if (i == '9')
        {
            let.push_back('w');
            let.push_back('x');
            let.push_back('y');
            let.push_back('z');
        }
        return let;
    }
};
```

### B

```c
class Solution
{
public:
    unordered_map<char, string> map = {{'2', "abc"}, {'3', "def"}, {'4', "ghi"}, {'5', "jkl"}, {'6', "mno"}, {'7', "pqrs"}, {'8', "tuv"}, {'9', "wxyz"}};
    vector<string> res;
    void backtrack(string &s, int index, string cur)
    {
        if (index == s.size())
        {
            res.push_back(cur);
            return;
        }
        for (int i = 0; i < map[s[index]].size(); ++i)
            backtrack(s, index + 1, cur + map[s[index]][i]);
    }
    vector<string> letterCombinations(string digits)
    {
        if (digits.size() == 0)
            return res;
        string cur;
        backtrack(digits, 0, cur);
        return res;
    }
};
```

### C

```c
class Solution
{
public:
    vector<string> letterCombinations(string digits)
    {
        if (digits.size() == 0)
            return {};
        map<char, string> a;
        a.insert(map<char, string>::value_type('2', "abc"));
        a.insert(map<char, string>::value_type('3', "def"));
        a.insert(map<char, string>::value_type('4', "ghi"));
        a.insert(map<char, string>::value_type('5', "jkl"));
        a.insert(map<char, string>::value_type('6', "mno"));
        a.insert(map<char, string>::value_type('7', "pqrs"));
        a.insert(map<char, string>::value_type('8', "tuv"));
        a.insert(map<char, string>::value_type('9', "wxyz"));
        int count = 1;
        for (int i = 0; i < digits.size(); i++)
        {
            count *= a[digits[i]].size();
        }
        vector<string> res(count);
        count = 1;
        for (int i = 0; i < digits.size(); i++)
        {
            int index = 0;
            vector<string> temp(res.begin(), res.begin() + count);
            for (int k = 0; k < count; k++)
            {
                for (auto c : a[digits[i]])
                {
                    res[index] = temp[k] + c;
                    index++;
                }
            }
            count *= a[digits[i]].size();
        }
        return res;
    }
};
```
