#include <iostream>
using namespace std;
typedef long long num;

/*(a*b)%mod*/
num fast_mul(num a, num b, num mod)
{
    num ans = 0;
    a = a % mod, b = b % mod;
    while (b != 0)
    {
        if (b & 1)
        {
            ans = (ans + a) % mod;
        }
        b >>= 1;
        a = (a + a) % mod;
    }
    return ans;
}

/*a^b%mod*/
num fast_pow(num a, num b, num mod)
{
    num ans = 1;
    num fns = a;
    while (b != 0)
    {
        if (b & 1)
            ans = fast_mul(ans, fns, mod);
        fns = fast_mul(fns, fns, mod);
        b >>= 1;
    }
    return ans;
}

/*eular function*/
num euler(num n)
{
    num ans = n;
    for (num i = 2; (i * i) <= n; i++)
    {
        if (n % i == 0)
        {
            ans = ans / i * (i - 1);
            while (n % i == 0)
                n = n / i;
        }
    }
    if (n > 1)
        ans = ans / n * (n - 1);
    return ans;
}

num find_q(num n)
{
    for (num i = 2; i < n; i++)
    {
        if (n % i == 0)
            return i;
    }
}

int main()
{
    num n = 1001733993063167141, d = 212353, C = 20190324; /*known*/
    num i, j, k;
    num q, p, e, X; /*unknown*/

    /*get q ,p ,k*/
    q = find_q(n);
    p = n / q;
    k = (p - 1) * (q - 1);

    /*get e*/
    e = fast_pow(d, euler(k) - 1, k);

    /*find x*/
    X = fast_pow(C, e, n);
    cout << X;
    return 0;
}
