#include <iostream>
#include <cstdio>
#include <algorithm>
using namespace std;

typedef struct
{
    int year, month, day;
} date;

bool isyn(int y)
{
    return (y % 4 == 0) || (y % 100 && y % 400 == 0);
}

void print(const date &d)
{
    printf("%02d-%02d-%02d\n", d.year, d.month, d.day);
}

bool compare(const date &d1, const date &d2)
{
    if (d1.year != d2.year)
    {
        return d1.year < d2.year;
    }
    if (d1.month != d2.month)
    {
        return d1.month < d2.month;
    }
    return d1.day < d2.day;
}

bool check(const date &d)
{
    static int month_days[] = {0, 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    if (isyn(d.year))
    {
        month_days[2] = 29;
    }
    else
    {
        month_days[2] = 28;
    }

    if (d.year < 1960 || d.year > 2059)
    {
        return false;
    }
    if (d.month < 1 || d.month > 12)
    {
        return false;
    }
    if (d.day < 1 || d.day > month_days[d.month])
    {
        return false;
    }
}

int main()
{
    int aa, bb, cc;
    scanf("%d/%d/%d", &aa, &bb, &cc);
    date d[6] = {
        {2000 + aa, bb, cc},
        {1900 + aa, bb, cc},
        {2000 + cc, aa, bb},
        {1900 + cc, aa, bb},
        {2000 + cc, bb, aa},
        {1900 + cc, bb, aa}};
    sort(d, d + 6, compare);
    for (int i = 0; i < 6; ++i)
    {
        if (check(d[i]))
        {
            print(d[i]);
        }
    }
    return 0;
}