# 大臣的旅费

**问题描述**

很久以前，T王国空前繁荣。为了更好地管理国家，王国修建了大量的快速路，用于连接首都和王国内的各大城市。  

为节省经费，T国的大臣们经过思考，制定了一套优秀的修建方案，使得任何一个大城市都能从首都直接或者通过其他大城市间接到达。同时，如果不重复经过大城市，从首都到达每个大城市的方案都是唯一的。  

J是T国重要大臣，他巡查于各大城市之间，体察民情。所以，从一个城市马不停蹄地到另一个城市成了J最常做的事情。他有一个钱袋，用于存放往来城市间的路费。  

聪明的J发现，如果不在某个城市停下来修整，在连续行进过程中，他所花的路费与他已走过的距离有关，在走第x千米到第x+1千米这一千米中（x是整数），他花费的路费是x+10这么多。也就是说走1千米花费11，走2千米要花费23。  

J大臣想知道：他从某一个城市出发，中间不休息，到达另一个城市，所有可能花费的路费中最多是多少呢？  

**输入格式**

输入的第一行包含一个整数n，表示包括首都在内的T王国的城市数

城市从1开始依次编号，1号城市为首都。

接下来n-1行，描述T国的高速路（T国的高速路一定是n-1条）

每行三个整数Pi, Qi, Di，表示城市Pi和城市Qi之间有一条高速路，长度为Di千米。

**输出格式**

输出一个整数，表示大臣J最多花费的路费是多少。

**样例输入1**

```
5
1 2 2
1 3 1
2 4 5
2 5 4
```

**样例输出1**

```
135
```

**输出格式**

```
大臣J从城市4到城市5要花费135的路费。
```

下面<span style="color:red">错误</span>的一项是？

## aop

### before

```c
#include <bits/stdc++.h>
using namespace std;
```

### after

```c

```

## 答案

```c
struct edge
{
    int to, cost;
};
vector<vector<edge>> G;
vector<bool> vst;
int n;
int ans, dis;
void dfs(int u, int d)
{
    vst[u] = true;
    if (d > dis)
        ans = u, dis = d;
    for (int i = 0; i < G[u].size(); i++)
    {
        int son = G[u][i].to;
        if (!vst[son])
            dfs(son, G[u][i].cost);
    }
    vst[u] = false;
}
int find(int u)
{
    ans = dis = 0;
    dfs(u, 0);
    return ans;
}
int main()
{
    scanf("%d", &n);
    G.resize(n + 5), vst.resize(n + 5);
    for (int i = 1; i < n; i++)
    {
        int p, q, d;
        scanf("%d %d %d", &p, &q, &d);
        G[p].push_back(edge{q, d});
        G[q].push_back(edge{p, d});
    }
    int x = find(1), y = find(x);
    printf("%d", dis * (dis + 1) / 2 + 10 * dis);
    return 0;
}
```
## 选项


### A

```c
const int maxd = 10000 + 50;

struct Point
{
    map<int, int> m;
    int status;
} p[maxd];

int r = 0, gps;

void f(int x, int ctn)
{
    p[x].status = 1;
    for (map<int, int>::iterator it = p[x].m.begin(); it != p[x].m.end(); it++)
    {
        if (p[it->first].status == 1)
            continue;
        f(it->first, ctn + it->second);
    }
    p[x].status = 0;
    if (r < ctn)
    {
        r = ctn;
        gps = x;
    }
}

int main()
{
    int n, i, x, y, l;
    cin >> n;
    for (i = 0; i < n - 1; i++)
    {
        cin >> x >> y >> l;
        p[x].m[y] = l;
        p[y].m[x] = l;
    }

    f(1, 0);

    f(gps, 0);

    cout << (21 + r) * r / 2;
    return 0;
}
```

### B

```c
#define _for(i, a, b) for (int i = a; i < b; i++)
#define _unfor(i, a, b) for (int i = a; i >= b; i--)
#define RI(a) scanf("%d", &a)
using namespace std;
typedef long long LL;
int d[111111], n, vis[111111], maxh = 0, p_h[111111], ans = 0;
vector<int> son[111111], G[111111], h_p[111111];
map<pair<int, int>, int> W;

int main()
{
    RI(n);
    _for(i, 1, n)
    {
        int a, b, c;
        RI(a);
        RI(b);
        RI(c);
        G[a].push_back(b);
        G[b].push_back(a);
        pair<int, int> pr(a > b ? a : b, a > b ? b : a);
        W[pr] = c;
    }

    queue<int> q;
    q.push(1);
    h_p[0].push_back(1);
    while (!q.empty())
    {
        int v = q.front(), len = G[v].size();
        q.pop();
        vis[v] = 1;
        _for(k, 0, len)
        {
            int e = G[v][k];
            if (!vis[e])
            {
                vis[e] = 1;
                son[v].push_back(e);
                q.push(e);
                maxh = max(maxh, p_h[e] = p_h[v] + 1);
                h_p[p_h[e]].push_back(e);
            }
        }
    }

    _unfor(h, maxh, 0)
    {
        int len = h_p[h].size();
        _for(k, 0, len)
        {
            int i = h_p[h][k], _max = 0, _cmax = 0;
            int len2 = son[i].size();
            _for(k2, 0, len2)
            {
                int j = son[i][k2], t;
                pair<int, int> pr(i > j ? i : j, i > j ? j : i);
                t = W[pr] + d[j];
                if (t > _cmax)
                    if ((_cmax = t) > _max)
                        swap(_max, _cmax);
                ans = max(ans, _max + _cmax);
            }
            d[i] = _max;
        }
    }
    cout << (LL)(ans + 1) * ans / 2 + ans * 10 << endl;
}
```

### C

```c
#define mem(a, b) memset(a, b, sizeof(a))
#define ll long long
const double eps = 3e-8;
const int mod = 10;
const int maxn = 10005;
vector<int> ed[maxn];
ll edge[maxn][maxn];
ll dis[maxn];
ll sum = 0;

int bfs(int node)
{
    mem(dis, -1);
    queue<int> que;
    que.push(node);
    int ans = node;
    dis[node] = 0;
    while (!que.empty())
    {
        int now = que.front();
        que.pop();
        for (int i = 0; i < ed[now].size(); i++)
        {
            int temp = ed[now][i];
            if (dis[temp] < 0)
            {
                dis[temp] = dis[now] + edge[now][temp];
                if (dis[temp] > sum)
                {
                    ans = temp;
                    sum = dis[temp];
                }
                que.push(temp);
            }
        }
    }
    return ans;
}

int main()
{
    int n, a, b;
    ll c;
    scanf("%d", &n);
    for (int i = 1; i < n; i++)
    {
        scanf("%d%d%lld", &a, &b, &c);
        ed[a].push_back(b);
        ed[b].push_back(a);
        edge[a][b] = c;
        edge[b][a] = c;
    }
    int starta = 1;
    int endnode, startnode;
    sum = 0;
    endnode = bfs(starta);
    sum = 0;
    startnode = bfs(endnode);

    double ans = sum * (sum + 1.0) / 2 + 10.0 * sum;
    printf("%.0f\n", ans);
}
```
