# 二叉树中的最大路径和

<p><strong>路径</strong> 被定义为一条从树中任意节点出发，沿父节点-子节点连接，达到任意节点的序列。同一个节点在一条路径序列中 <strong>至多出现一次</strong> 。该路径<strong> 至少包含一个 </strong>节点，且不一定经过根节点。</p>

<p><strong>路径和</strong> 是路径中各节点值的总和。</p>

<p>给你一个二叉树的根节点 <code>root</code> ，返回其 <strong>最大路径和</strong> 。</p>



<p><strong>示例 1：</strong></p>
<img alt="" src="https://img-blog.csdnimg.cn/img_convert/ca0d0d9f728f2aeda1976de9b08940e5.png#pic_center" />
<pre>
<strong>输入：</strong>root = [1,2,3]

<strong>输出：</strong>6

<strong>解释：</strong>最优路径是 2 -> 1 -> 3 ，路径和为 2 + 1 + 3 = 6</pre>

<p><strong>示例 2：</strong></p>
<img alt="" src="https://img-blog.csdnimg.cn/img_convert/730fd58fb57c0fbc6d5f77b18e9d6b50.png#pic_center" />
<pre>
<strong>输入：</strong>root = [-10,9,20,null,null,15,7]

<strong>输出：</strong>42

<strong>解释：</strong>最优路径是 15 -> 20 -> 7 ，路径和为 15 + 20 + 7 = 42
</pre>



<p><strong>提示：</strong></p>

<ul>
	<li>树中节点数目范围是 <code>[1, 3 * 10<sup>4</sup>]</code></li>
	<li><code>-1000 <= Node.val <= 1000</code></li>
</ul>

<p>以下<span style="color:red">错误</span>的选项是？</p>

## aop

### before

```c
#include <bits/stdc++.h>
using namespace std;

struct TreeNode
{
    int val;
    TreeNode *left;
    TreeNode *right;
    TreeNode() : val(0), left(nullptr), right(nullptr) {}
    TreeNode(int x) : val(x), left(nullptr), right(nullptr) {}
    TreeNode(int x, TreeNode *left, TreeNode *right) : val(x), left(left), right(right) {}
};
```

### after

```c

```

## 答案

```c
class Solution
{
public:
    int maxv = -123123632;
    int maxPathSum(TreeNode *root)
    {
        if (root == NULL)
            return 0;
        calc(root);
        return maxv;
    }

    int calc(TreeNode *root)
    {
        if (root == NULL)
            return 0;
        int temp = root->val;
        int lmaxsum = calc(root->left);
        int rmaxsum = calc(root->right);

        if (lmaxsum > 0)
            temp += lmaxsum;
        if (rmaxsum > 0)
            temp += rmaxsum;
        return max(root->val, max(root->val + lmaxsum, root->val + rmaxsum));
    }
};
```
## 选项


### A

```c
class Solution
{
    int res = INT_MIN;

public:
    int maxPathSum(TreeNode *root)
    {

        int p = getdfs(root);
        return res;
    }
    int getdfs(TreeNode *node)
    {
        if (node == NULL)
            return 0;
        int left = max(getdfs(node->left), 0);
        int right = max(getdfs(node->right), 0);
        int size = left + right + node->val;
        res = res > size ? res : size;
        right = right > left ? right : left;
        node->val = right + node->val;
        return node->val;
    }
};
```

### B

```c
class Solution
{
public:
    int ans = 0;
    int OneSideMax(TreeNode *root)
    {
        if (root == nullptr)
            return 0;

        int left = max(0, OneSideMax(root->left));
        int right = max(0, OneSideMax(root->right));

        ans = max(ans, left + right + root->val);
        return max(left, right) + root->val;
    }

    int maxPathSum(TreeNode *root)
    {
        OneSideMax(root);
        return ans;
    }
};
```

### C

```c
class Solution
{
public:
    int dfs(TreeNode *root, int &res)
    {
        if (root == NULL)
        {
            return 0;
        }
        int left = max(dfs(root->left, res), 0);
        int right = max(dfs(root->right, res), 0);
        res = max(res, root->val + left + right);

        return root->val + max(left, right);
    }
    int maxPathSum(TreeNode *root)
    {
        int res = INT_MIN;
        dfs(root, res);
        return res;
    }
};
```
