# 验证二叉搜索树

<div class="notranslate">
    <p>给你一个二叉树的根节点 <code>root</code> ，判断其是否是一个有效的二叉搜索树。</p>

    <p><strong>有效</strong> 二叉搜索树定义如下：</p>

    <ul>
        <li>节点的左子树只包含<strong> 小于 </strong>当前节点的数。</li>
        <li>节点的右子树只包含 <strong>大于</strong> 当前节点的数。</li>
        <li>所有左子树和右子树自身必须也是二叉搜索树。</li>
    </ul>

    <p>&nbsp;</p>

    <p><strong>示例 1：</strong></p>
    <img style="width: 302px; height: 182px;" src="https://assets.leetcode.com/uploads/2020/12/01/tree1.jpg" alt="">
    <pre><strong>输入：</strong>root = [2,1,3]
<strong><br />输出：</strong>true
</pre>

    <p><strong>示例 2：</strong></p>
    <img style="width: 422px; height: 292px;" src="https://assets.leetcode.com/uploads/2020/12/01/tree2.jpg" alt="">
    <pre><strong>输入：</strong>root = [5,1,4,null,null,3,6]
<strong><br />输出：</strong>false
<strong><br />解释：</strong>根节点的值是 5 ，但是右子节点的值是 4 。
</pre>

    <p>&nbsp;</p>

    <p><strong>提示：</strong></p>

    <ul>
        <li>树中节点数目范围在<code>[1, 10<sup>4</sup>]</code> 内</li>
        <li><code>-2<sup>31</sup> &lt;= Node.val &lt;= 2<sup>31</sup> - 1</code></li>
    </ul>
</div>
<p>以下错误的选项是？</p>

## aop
### before
```cpp
#include <bits/stdc++.h>
using namespace std;

struct TreeNode
{
    int val;
    TreeNode *left;
    TreeNode *right;
    TreeNode() : val(0), left(nullptr), right(nullptr) {}
    TreeNode(int x) : val(x), left(nullptr), right(nullptr) {}
    TreeNode(int x, TreeNode *left, TreeNode *right) : val(x), left(left), right(right) {}
};
```
### after
```cpp

```

## 答案
```cpp
class Solution
{
public:
    bool judge(TreeNode *root, long start, long end)
    {
        if (!root)
            return true;
        if (start >= root->val || end <= root->val)
            return false;
        return judge(root->left, start, root->val);
    }

    bool isValidBST(TreeNode *root)
    {
        long start = INT_MIN - 1;
        long end = INT_MAX + 1;
        return judge(root, start, end);
    }
};
```
## 选项

### A
```cpp
class Solution
{
public:
    TreeNode *pre;
    bool isValidBST(TreeNode *root)
    {
        if (!root)
            return true;
        if (!isValidBST(root->left))
            return false;
        if (pre && pre->val >= root->val)
            return false;
        pre = root;
        if (!isValidBST(root->right))
            return false;
        return true;
    }
};
```

### B
```cpp
class Solution
{
public:
    void midorder(TreeNode *root, vector<int> &arr)
    {
        if (root)
        {
            midorder(root->left, arr);
            arr.push_back(root->val);
            midorder(root->right, arr);
        }
    }
    bool isValidBST(TreeNode *root)
    {
        vector<int> arr;
        midorder(root, arr);
        for (int i = 1; i < arr.size(); i++)
        {
            if (arr[i] <= arr[i - 1])
                return false;
        }
        return true;
    }
};
```

### C
```cpp
class Solution
{
public:
    bool isValidBST(TreeNode *root)
    {
        if (root)
        {
            long long f = -0x3f3f3f3f3f3f;
            return dfs(root, f);
        }
        else
            return true;
    }

    bool dfs(TreeNode *root, long long &f_val)
    {
        bool res = true;
        if (root)
        {
            res &= dfs(root->left, f_val) && (root->val > f_val);
            if (!res)
                return false;
            f_val = root->val;
            res &= dfs(root->right, f_val);
        }
        return res;
    }
};
```
