# 通配符匹配

<p>给定一个字符串&nbsp;(<code>s</code>) 和一个字符模式&nbsp;(<code>p</code>) ，实现一个支持&nbsp;<code>&#39;?&#39;</code>&nbsp;和&nbsp;<code>&#39;*&#39;</code>&nbsp;的通配符匹配。</p><pre>&#39;?&#39; 可以匹配任何单个字符。&#39;*&#39; 可以匹配任意字符串（包括空字符串）。</pre><p>两个字符串<strong>完全匹配</strong>才算匹配成功。</p><p><strong>说明:</strong></p><ul>	<li><code>s</code>&nbsp;可能为空，且只包含从&nbsp;<code>a-z</code>&nbsp;的小写字母。</li>	<li><code>p</code>&nbsp;可能为空，且只包含从&nbsp;<code>a-z</code>&nbsp;的小写字母，以及字符&nbsp;<code>?</code>&nbsp;和&nbsp;<code>*</code>。</li></ul><p><strong>示例&nbsp;1:</strong></p><pre><strong>输入:</strong>s = &quot;aa&quot;p = &quot;a&quot;<strong><br />输出:</strong> false<strong><br />解释:</strong> &quot;a&quot; 无法匹配 &quot;aa&quot; 整个字符串。</pre><p><strong>示例&nbsp;2:</strong></p><pre><strong>输入:</strong>s = &quot;aa&quot;p = &quot;*&quot;<strong><br />输出:</strong> true<strong><br />解释:</strong>&nbsp;&#39;*&#39; 可以匹配任意字符串。</pre><p><strong>示例&nbsp;3:</strong></p><pre><strong>输入:</strong>s = &quot;cb&quot;p = &quot;?a&quot;<strong><br />输出:</strong> false<strong><br />解释:</strong>&nbsp;&#39;?&#39; 可以匹配 &#39;c&#39;, 但第二个 &#39;a&#39; 无法匹配 &#39;b&#39;。</pre><p><strong>示例&nbsp;4:</strong></p><pre><strong>输入:</strong>s = &quot;adceb&quot;p = &quot;*a*b&quot;<strong><br />输出:</strong> true<strong><br />解释:</strong>&nbsp;第一个 &#39;*&#39; 可以匹配空字符串, 第二个 &#39;*&#39; 可以匹配字符串 &quot;dce&quot;.</pre><p><strong>示例&nbsp;5:</strong></p><pre><strong>输入:</strong>s = &quot;acdcb&quot;p = &quot;a*c?b&quot;<strong><br />输出:</strong> false</pre>
<p>以下错误的选项是？</p>

## aop
### before
```cpp
#include <bits/stdc++.h>
using namespace std;
```
### after
```cpp
int main()
{
    Solution sol;
    string s = "adceb", p = "*a*b";
    bool res;

    res = sol.isMatch(s, p);

    cout << res;
    return 0;
}
```

## 答案
```cpp
class Solution
{
public:
    bool isMatch(string s, string p)
    {
        if (s == "" && p == "" || (s == "" && p == "*"))
            return true;
        if (s == p)
            return true;
        int lens = s.length();
        int lenp = p.length();
        bool questionm = false, starm = false;
        for (int k = 0; k < lenp; k++)
        {
            if (p[k] == '?')
                questionm = true;
            if (p[k] == '*')
                starm = true;
        }
        if (lenp != lens && questionm == false && starm == false)
            return false;
        int i = 0, j = 0;
        int mstar, sstar = -1;
        while (i < lens)
        {
            if (j < lenp && p[j] == '*')
            {
                mstar = i;
                sstar = j;
                j += 1;
            }
            else if (sstar != -1)
            {
                mstar += 1;
                j = sstar + 1;
                i = mstar;
            }
            else
                return false;
        }
        while (j < lenp)
        {
            if (p[j] != '*')
                return false;
            j++;
        }
        return true;
    }
};
```
## 选项

### A
```cpp
class Solution
{
public:
    bool isMatch(string s, string p)
    {
        int m = s.size();
        int n = p.size();

        vector<vector<int>> dp(m + 1, vector<int>(n + 1));
        dp[0][0] = true;

        for (int i = 1; i <= n; i++)
        {
            if (p[i - 1] == '*')
                dp[0][i] = true;
            else
                break;
        }

        for (int i = 1; i <= m; i++)
        {
            for (int j = 1; j <= n; j++)
            {

                if (p[j - 1] == '*')
                {
                    dp[i][j] |= dp[i][j - 1];
                    dp[i][j] |= dp[i - 1][j];
                }
                else
                {
                    if (p[j - 1] == '?' || s[i - 1] == p[j - 1])
                    {
                        dp[i][j] |= dp[i - 1][j - 1];
                    }
                }
            }
        }

        return dp[m][n];
    }
};

```

### B
```cpp
class Solution
{
public:
    bool isMatch(string s, string p)
    {
        vector<vector<bool>> dp(s.size() + 1, vector<bool>(p.size() + 1));
        dp[0][0] = 1;
        for (int j = 1; j <= p.size(); j++)
        {
            dp[0][j] = dp[0][j - 1] && p[j - 1] == '*';
        }
        for (int i = 1; i <= s.size(); i++)
        {
            for (int j = 1; j <= p.size(); j++)
            {
                if (p[j - 1] == '*')
                {
                    dp[i][j] = dp[i][j - 1] || dp[i - 1][j];
                }
                else
                {
                    dp[i][j] = (s[i - 1] == p[j - 1] || p[j - 1] == '?') && dp[i - 1][j - 1];
                }
            }
        }
        return dp[s.size()][p.size()];
    }
};
```

### C
```cpp
class Solution
{
public:
    bool isMatch(string s, string p)
    {
        if (p.empty())
            return s.empty();
        if (s.empty())
        {
            if (p[0] == '*')
                return isMatch(s, p.substr(1));
            else
                return false;
        }

        if (p[0] == '*')
            return isMatch(s, p.substr(1)) || isMatch(s.substr(1), p);
        else
            return (s[0] == p[0] || p[0] == '?') && isMatch(s.substr(1), p.substr(1));
    }
};
```
