# 删除有序数组中的重复项

<div class="notranslate">
    <p>给你一个有序数组 <code>nums</code> ，请你<strong><a href="http://baike.baidu.com/item/%E5%8E%9F%E5%9C%B0%E7%AE%97%E6%B3%95">
                原地</a></strong> 删除重复出现的元素，使每个元素 <strong>只出现一次</strong> ，返回删除后数组的新长度。</p>

    <p>不要使用额外的数组空间，你必须在 <strong><a href="https://baike.baidu.com/item/%E5%8E%9F%E5%9C%B0%E7%AE%97%E6%B3%95">原地
            </a>修改输入数组 </strong>并在使用 O(1) 额外空间的条件下完成。</p>

    <p>&nbsp;</p>

    <p><strong>说明:</strong></p>

    <p>为什么返回数值是整数，但输出的答案是数组呢?</p>

    <p>请注意，输入数组是以<strong>「引用」</strong>方式传递的，这意味着在函数里修改输入数组对于调用者是可见的。</p>

    <p>你可以想象内部操作如下:</p>

    <pre>// <strong>nums</strong> 是以“引用”方式传递的。也就是说，不对实参做任何拷贝
int len = removeDuplicates(nums);

// 在函数里修改输入数组对于调用者是可见的。
// 根据你的函数返回的长度, 它会打印出数组中<strong> 该长度范围内</strong> 的所有元素。
for (int i = 0; i &lt; len; i++) {
&nbsp; &nbsp; print(nums[i]);
}
</pre>
    &nbsp;

    <p><strong>示例 1：</strong></p>

    <pre><strong>输入：</strong>nums = [1,1,2]
<strong><br />输出：</strong>2, nums = [1,2]
<strong><br />解释：</strong>函数应该返回新的长度 <strong>2</strong> ，并且原数组 <em>nums </em>的前两个元素被修改为 <strong>1</strong>, <strong>2 </strong>。不需要考虑数组中超出新长度后面的元素。
    </pre>

    <p><strong>示例 2：</strong></p>

    <pre><strong>输入：</strong>nums = [0,0,1,1,1,2,2,3,3,4]
<strong><br />输出：</strong>5, nums = [0,1,2,3,4]
<strong><br />解释：</strong>函数应该返回新的长度 <strong>5</strong> ， 并且原数组 <em>nums </em>的前五个元素被修改为 <strong>0</strong>, <strong>1</strong>, <strong>2</strong>, <strong>3</strong>, <strong>4</strong> 。不需要考虑数组中超出新长度后面的元素。
    </pre>

    <p>&nbsp;</p>

    <p><strong>提示：</strong></p>

    <ul>
        <li><code>0 &lt;= nums.length &lt;= 3 * 10<sup>4</sup></code></li>
        <li><code>-10<sup>4</sup> &lt;= nums[i] &lt;= 10<sup>4</sup></code></li>
        <li><code>nums</code> 已按升序排列</li>
    </ul>

    <p>&nbsp;</p>
</div>
<p>以下错误的选项是？</p>

## aop
### before
```cpp
#include <bits/stdc++.h>
using namespace std;
```
### after
```cpp
int main()
{
    Solution sol;
    int res;

    int arr1[] = {1, 1, 2};

    int length1 = sizeof(arr1) / sizeof(arr1[0]);

    vector<int> nums1(arr1, arr1 + length1);

    res = sol.removeDuplicates(nums1);

    cout << res;
    return 0;
}
```

## 答案
```cpp
class Solution
{
public:
    int removeDuplicates(vector<int> &nums)
    {
        if (nums.size() == 0)
            return 0;
        int i = 0;
        for (int j = 1; j < nums.size(); j++)
        {
            if (nums[j] != nums[i])
            {
                i++;
                nums[i] = nums[j];
            }
        }
        return i;
    }
};
```
## 选项

### A
```cpp
class Solution
{
public:
    int removeDuplicates(vector<int> &nums)
    {
        int len = 0;
        int i = 0;
        int j = 0;
        for (i = 0, j = i + 1;; j++)
        {
            if (j >= nums.size())
            {
                break;
            }
            if (nums[i] != nums[j])
            {
                nums[i + 1] = nums[j];
                i++;
            }
        }
        len = nums.size() < i + 1 ? nums.size() : i + 1;
        return len;
    }
};
```

### B
```cpp
class Solution
{
public:
    int removeDuplicates(vector<int> &nums)
    {
        int slow = 1, fast = 1;
        if (nums.size() == 0)
            return 0;
        while (fast < nums.size())
        {
            if (nums[fast] != nums[fast - 1])
                nums[slow++] = nums[fast++];
            else
                fast++;
        }
        return slow;
    }
};
```

### C
```cpp
class Solution
{
public:
    int removeDuplicates(vector<int> &nums)
    {
        if (nums.size() == 0)
        {
            return 0;
        }
        if (nums.size() == 1)
        {
            return 1;
        }
        vector<int>::iterator slow = nums.begin() + 1;
        for (vector<int>::iterator fast = nums.begin() + 1; fast != nums.end(); fast++)
        {
            if (*fast != *(fast - 1))
            {
                *slow = *fast;
                slow++;
            }
        }
        nums.erase(slow, nums.end());
        return nums.size();
    }
};
```
