# 回文数

<p>给你一个整数 <code>x</code> ，如果 <code>x</code> 是一个回文整数，返回 <code>true</code> ；否则，返回 <code>false</code> 。</p><p>回文数是指正序（从左向右）和倒序（从右向左）读都是一样的整数。例如，<code>121</code> 是回文，而 <code>123</code> 不是。</p><p> </p><p><strong>示例 1：</strong></p><pre><strong>输入：</strong>x = 121<strong><br />输出：</strong>true</pre><p><strong>示例 2：</strong></p><pre><strong>输入：</strong>x = -121<strong><br />输出：</strong>false<strong><br />解释：</strong>从左向右读, 为 -121 。 从右向左读, 为 121- 。因此它不是一个回文数。</pre><p><strong>示例 3：</strong></p><pre><strong>输入：</strong>x = 10<strong><br />输出：</strong>false<strong><br />解释：</strong>从右向左读, 为 01 。因此它不是一个回文数。</pre><p><strong>示例 4：</strong></p><pre><strong>输入：</strong>x = -101<strong><br />输出：</strong>false</pre><p> </p><p><strong>提示：</strong></p><ul>	<li><code>-2<sup>31</sup> <= x <= 2<sup>31</sup> - 1</code></li></ul><p> </p><p><strong>进阶：</strong>你能不将整数转为字符串来解决这个问题吗？</p>
<p>以下错误的选项是？</p>

## aop

### before

```cpp
#include <bits/stdc++.h>
using namespace std;
```
### after

```cpp
int main()
{
    Solution sol;
    cout << sol.isPalindrome(1121) << endl;
    return 0;
}

```

## 答案

```cpp
class Solution
{
public:
    bool isPalindrome(int x)
    {
        string s = to_string(x);
        for (int i = 0; i < s.length(); ++i)
        {
            if (s[i] != s[s.length() - i])
                return false;
        }
        return true;
    }
};
```
## 选项


### A

```cpp

class Solution
{
public:
    bool isPalindrome(int x)
    {
        if (x < 0)
            return false;
        double sum;
        int m = x;
        while (x)
        {
            sum = sum * 10 + x % 10;
            x = x / 10;
        }
        if (m == sum)
            return true;
        else
            return false;
    }
};
```

### B

```cpp
class Solution
{
public:
    bool isPalindrome(int x)
    {
        int midrev = 0;
        if (x < 0 || (x % 10 == 0 && x != 0))
            return false;
        while (x > midrev)
        {
            midrev = midrev * 10 + x % 10;
            x /= 10;
        }
        return midrev == x || midrev / 10 == x;
    }
};
```

### C

```cpp
class Solution
{
public:
    bool isPalindrome(int x)
    {
        long rev;
        if (x < 0)
            return false;
        string str_x = to_string(x);
        std::reverse(str_x.begin(), str_x.end());
        stringstream out(str_x);
        out >> rev;
        return x == rev;
    }
};
```
