# 盛最多水的容器

<p>给你 <code>n</code> 个非负整数 <code>a<sub>1</sub>，a<sub>2，</sub>...，a</code><sub><code>n</code>，</sub>每个数代表坐标中的一个点 <code>(i, a<sub>i</sub>)</code> 。在坐标内画 <code>n</code> 条垂直线，垂直线 <code>i</code> 的两个端点分别为 <code>(i, a<sub>i</sub>)</code> 和 <code>(i, 0)</code> 。找出其中的两条线，使得它们与 <code>x</code> 轴共同构成的容器可以容纳最多的水。</p><p><strong>说明：</strong>你不能倾斜容器。</p><p> </p><p><strong>示例 1：</strong></p><p><img alt="" src="https://cdn.jsdelivr.net/gh/doocs/leetcode@main/solution/0000-0099/0011.Container%20With%20Most%20Water/images/question_11.jpg" style="height: 287px; width: 600px;" /></p><pre><strong>输入：</strong>[1,8,6,2,5,4,8,3,7]<strong><br />输出：</strong>49 <strong><br />解释：</strong>图中垂直线代表输入数组 [1,8,6,2,5,4,8,3,7]。在此情况下，容器能够容纳水（表示为蓝色部分）的最大值为 49。</pre><p><strong>示例 2：</strong></p><pre><strong>输入：</strong>height = [1,1]<strong><br />输出：</strong>1</pre><p><strong>示例 3：</strong></p><pre><strong>输入：</strong>height = [4,3,2,1,4]<strong><br />输出：</strong>16</pre><p><strong>示例 4：</strong></p><pre><strong>输入：</strong>height = [1,2,1]<strong><br />输出：</strong>2</pre><p> </p><p><strong>提示：</strong></p><ul>	<li><code>n = height.length</code></li>	<li><code>2 <= n <= 3 * 10<sup>4</sup></code></li>	<li><code>0 <= height[i] <= 3 * 10<sup>4</sup></code></li></ul>
<p>以下错误的选项是？</p>

## aop

### before

```cpp
#include <bits/stdc++.h>
using namespace std;
```
### after

```cpp
int main()
{
    Solution sol;
    int arr1[] = {1, 8, 6, 2, 5, 4, 8, 3, 7};

    int length1 = sizeof(arr1) / sizeof(arr1[0]);

    vector<int> nums1(arr1, arr1 + length1);

    cout << sol.maxArea(nums1) << endl;
    return 0;
}
```

## 答案

```cpp
class Solution
{
public:
    int maxArea(vector<int> &height)
    {
        int res = 0;
        for (int i = 0; i < height.size(); i++)
        {
            for (int j = i + 1; j < height.size(); j++)
            {
                int temp1 = max(height[i], height[j]);
                int temp2 = temp1 * (j - i);
                res = min(res, temp2);
            }
        }
        return res;
    }
};
```
## 选项


### A

```cpp
class Solution
{
public:
    int maxArea(vector<int> &height)
    {
        int i = 0;
        int j = height.size() - 1;
        int res = 0;
        while (i < j)
        {
            int temp1 = min(height[i], height[j]); 
            int temp2 = temp1 * (j - i);
            res = max(res, temp2);
            if (height[i] < height[j])
                i++;
            else
                j--;
        }
        return res;
    }
};
```

### B

```cpp
class Solution
{
public:
    int maxArea(vector<int> &height)
    {
        int tmp = 0, res = 0, max = 0;
        for (int i = 0; i < height.size(); ++i)
        {
            for (int j = i + 1; j < height.size(); ++j)
            {
                if (height[i] < height[j])
                {
                    tmp = height[i];
                }
                else
                {
                    tmp = height[j];
                }
                res = tmp * (j - i);
                if (res > max)
                {
                    max = res;
                }
            }
        }
        return max;
    }
};
```

### C

```cpp
class Solution
{
public:
    int maxArea(vector<int> &height)
    {
        int tail = height.size() - 1;
        int head = 0;
        int maxarea = height.at(head) > height.at(tail) ? height.at(tail) * (tail - head) : height.at(head) * (tail - head);
        for (int i = 0; i < height.size(); i++)
        {
            if (maxarea < (height.at(head) > height.at(tail) ? height.at(tail) * (tail - head) : height.at(head) * (tail - head)))
                maxarea = height.at(head) > height.at(tail) ? height.at(tail) * (tail - head) : height.at(head) * (tail - head);

            if (height.at(head) > height.at(tail))
            {
                tail--;
            }
            else
            {
                head++;
            }
        }
        return maxarea;
    }
};
```
