# 区间和的个数

<p>给你一个整数数组 <code>nums</code> 以及两个整数 <code>lower</code> 和 <code>upper</code> 。求数组中，值位于范围 <code>[lower, upper]</code> （包含 <code>lower</code> 和 <code>upper</code>）之内的 <strong>区间和的个数</strong> 。</p>

<p><strong>区间和</strong> <code>S(i, j)</code> 表示在 <code>nums</code> 中，位置从 <code>i</code> 到 <code>j</code> 的元素之和，包含 <code>i</code> 和 <code>j</code> (<code>i</code> ≤ <code>j</code>)。</p>

<p> </p>
<strong>示例 1：</strong>

<pre>
<strong>输入：</strong>nums = [-2,5,-1], lower = -2, upper = 2
<strong>输出：</strong>3
<strong>解释：</strong>存在三个区间：[0,0]、[2,2] 和 [0,2] ，对应的区间和分别是：-2 、-1 、2 。
</pre>

<p><strong>示例 2：</strong></p>

<pre>
<strong>输入：</strong>nums = [0], lower = 0, upper = 0
<strong>输出：</strong>1
</pre>

<p> </p>

<p><strong>提示：</strong></p>

<ul>
	<li><code>1 <= nums.length <= 10<sup>5</sup></code></li>
	<li><code>-2<sup>31</sup> <= nums[i] <= 2<sup>31</sup> - 1</code></li>
	<li><code>-10<sup>5</sup> <= lower <= upper <= 10<sup>5</sup></code></li>
	<li>题目数据保证答案是一个 <strong>32 位</strong> 的整数</li>
</ul>

<p>以下错误的选项是？</p>

## aop

### before

```cpp
#include <bits/stdc++.h>
using namespace std;
```
### after

```cpp
int main()
{
    Solution sol;
    int res;
    vector<int> nums = {-2, 5, -1};
    int lower = -2;
    int upper = 2;
    res = sol.countRangeSum(nums, lower, upper);
    cout << res;
    return 0;
}
```

## 答案

```cpp
class Solution
{
public:
    int lower, upper, res;
    long tmp[10000];
    void merge(vector<long> &a, int l, int mid, int r)
    {
        int i = l, j = mid + 1, k = 0;
        while (i <= mid && j <= r)
        {
            if (a[i] <= a[j])
                tmp[k++] = a[i++];
            else
                tmp[k++] = a[j++];
        }
        while (i <= mid)
            tmp[k++] = a[i++];
        while (j <= r)
            tmp[k++] = a[j++];
        copy(tmp, tmp + k, a.begin() + l);
    }
    void merge_sort(vector<long> &a, int l, int r)
    {
        if (l >= r)
            return;
        int mid = l + r - l / 2;
        merge_sort(a, l, mid);
        merge_sort(a, mid + 1, r);

        int k = mid + 1, j = k;
        for (int i = l; i <= mid; ++i)
        {
            while (k <= r && a[k] - a[i] < lower)
                ++k;
            while (j <= r && a[j] - a[i] <= upper)
                ++j;
            res += j - k;
        }
        if (a[mid] <= a[mid + 1])
            return;
        merge(a, l, mid, r);
    }
    int countRangeSum(vector<int> &nums, int lower, int upper)
    {
        this->lower = lower;
        this->upper = upper;
        int n = nums.size();
        vector<long> presum(n + 1, 0);
        for (int i = 0; i < n; ++i)
            presum[i] = presum[i] + nums[i];
        merge_sort(presum, 0, n);
        return res;
    }
};
```
## 选项


### A

```cpp
class Solution
{
public:
    int countRangeSum(vector<int> &nums, int lower, int upper)
    {
        int n = nums.size();
        long presum = 0;

        multiset<long> S;
        S.insert(0);
        int ret = 0;

        for (int i = 0; i < n; i++)
        {
            presum += nums[i];

            ret += distance(S.lower_bound(presum - upper), S.upper_bound(presum - lower));
            S.insert(presum);
        }
        return ret;
    }
};
```

### B

```cpp
class Solution
{
public:
    int countRangeSum(vector<int> &nums, int lower, int upper)
    {
        int n = nums.size();
        long presum = 0;
        vector<long> S(n + 1, 0);
        int ret = 0;
        for (int i = 1; i <= n; i++)
        {
            presum += nums[i - 1];
            for (int j = 1; j <= i; j++)
            {
                if (lower <= presum - S[j - 1] && presum - S[j - 1] <= upper)
                    ret++;
            }
            S[i] = presum;
        }
        return ret;
    }
};
```

### C

```cpp
class Solution
{
public:
    int countRangeSum(vector<int> &nums, int lower, int upper)
    {
        int count = 0;
        for (int i = 0; i < nums.size(); ++i)
        {
            if (nums[i] <= upper && nums[i] >= lower)
                ++count;
            long sum = nums[i];
            for (int j = i + 1; j < nums.size(); ++j)
            {
                sum += nums[j];
                if (sum <= upper && sum >= lower)
                    ++count;
            }
        }
        return count;
    }
};
```
