# 超级胶水

小明有n颗石子，按顺序摆成一排。他准备用胶水将这些石子粘在一起。每颗石子有自己的重量，如果将两颗石子粘在一起，将合并成一颗新的石子，重量是这两颗石子的重量之和。  
为了保证石子粘贴牢固，粘贴两颗石子所需要的胶水与两颗石子的重量乘积成正比，本题不考虑物理单位，认为所需要的胶水在数值上等于两颗石子重量的乘积。  
每次合并，小明只能合并位置相邻的两颗石子，并将合并出的新石子放在原来的位置。  
现在，小明想用最少的胶水将所有石子粘在一起，请帮助小明计算最少需要多少胶水。  

测试样例

输入 
```
3 

3 4 5
```
输出
```
47
```


## aop

### before

```cpp
#include<bits/stdc++.h>
using namespace std;
 
 
const int maxn=100005;
 
int numv[maxn];
int v[maxn];
 
```
### after

```cpp
 
int main(){
	
	int n;
	scanf("%d",&n);
		for(int i=0;i<n;i++){
			scanf("%d",&v[i]);
			if(i==0) numv[i]=v[i];
			numv[i]=numv[i-1]+v[i];
		}
	
	printf("%d",dfs(n-1));
	
}
```

## 答案

```cpp
 
int dfs(int idx){
	if(idx==0)
	return 0;
	
	if(idx==1)
	return v[0]*v[1];
	
	int max_,a=0x3f3f3f,b=0x3f3f3f3f,c=0;
	if(idx>=2) 
	a=(v[idx]*v[idx-1]+dfs(idx-2)+numv[idx-2]*(v[idx]+v[idx-1]));    
	b=v[idx]*numv[idx-1]+dfs(idx-1);                                 
	c=min(a,b);
	return c;
}
```
## 选项


### A

```cpp
int dfs(int idx)
{
	if (idx == 0)
		return 0;

	if (idx == 1)
		return v[0] * v[1];

	int max_, a = 0x3f3f3f, b = 0x3f3f3f3f, c = 0;
	if (idx >= 2)
		a = (v[idx] * v[idx] + dfs(idx - 2) + numv[idx - 2] * (v[idx] + v[idx - 1])); 
	b = v[idx] * numv[idx] + dfs(idx - 1);											  
	c = min(a, b);
	return c;
}
```

### B

```cpp
int dfs(int idx)
{
	if (idx == 0)
		return 0;

	if (idx == 1)
		return v[0] * v[1];

	int max_, a = 0x3f3f3f, b = 0x3f3f3f3f, c = 0;
	if (idx >= 2)
		a = (v[idx - 2] * v[idx] + dfs(idx - 2) + numv[idx - 2] * (v[idx] + v[idx - 1])); 
	b = v[idx - 2] * numv[idx] + dfs(idx - 1);											  
	c = min(a, b);
	return c;
}
```

### C

```cpp
int dfs(int idx)
{
	if (idx == 0)
		return 0;

	if (idx == 1)
		return v[0] * v[1];

	int max_, a = 0x3f3f3f, b = 0x3f3f3f3f, c = 0;
	if (idx >= 2)
		a = (v[idx] * v[idx] + dfs(idx - 2) + numv[idx - 2] * (v[idx] + v[idx - 1])); 
	b = v[idx - 1] * numv[idx] + dfs(idx - 1);										  
	c = min(a, b);
	return c;
}
```
