# 交换瓶子

有N个瓶子，编号 1 ~ N，放在架子上。  

比如有5个瓶子：  

```json
2 1 3 5 4  
```

要求每次拿起2个瓶子，交换它们的位置。  

经过若干次后，使得瓶子的序号为：  

```json
1 2 3 4 5  
```

对于这么简单的情况，显然，至少需要交换2次就可以复位。  

如果瓶子更多呢？你可以通过编程来解决。  

输入格式为两行：  

第一行: 一个正整数N（N<10000）, 表示瓶子的数目  

第二行：N个正整数，用空格分开，表示瓶子目前的排列情况。  

输出数据为一行一个正整数，表示至少交换多少次，才能完成排序。  

例如，输入：  

```json
5
3 1 2 5 4
```

程序应该输出：

```json
3
```

再例如，输入：

```json
5
5 4 3 2 1
```

程序应该输出：

```json
2
```

以下<span style="color:red">错误</span>的一项是？


## aop

### before

```c
#include <bits/stdc++.h>
using namespace std;
```

### after

```c

```

## 答案

```c
int search(int i);
int n;
int a[10000] = {0};
int main(void)
{
    int index, count, i;
    index = count = 0;
    scanf("%d", &n);
    for (i = 0; i < n; i++)
    {
        scanf("%d", &a[i]);
    }

    for (i = 0; i < n; i++)
    {
        int j = search(i);
        if (a[index] != a[j])
        {
            int t = a[index];
            a[index] = a[j];
            a[j] = t;
            count++;
            index++;
        }
    }

    printf("%d", count);
    return 0;
}

int search(int i)
{
    int index, j, k, min;
    min = 99999;
    for (j = i; j < n; j++)
    {
        if (min > a[j])
        {
            min = a[j];
            index = j;
        }
    }
    return index;
}
```

## 选项

### A

```c
int main()
{
    int n, a[10005];
    cin >> n;
    for (int i = 1; i <= n; i++)
        cin >> a[i];
    int num = 0;
    for (int i = 1; i <= n; i++)
    {
        while (a[i] != i)
        {
            swap(a[i], a[a[i]]);
            num++;
        }
    }
    cout << num << endl;
    return 0;
}
```

### B

```c
int main()
{
    int n;
    cin >> n;
    int a[n + 5];
    for (int i = 0; i < n; i++)
        cin >> a[i];
    int min;
    int num = 0;
    for (int i = 0; i < n; i++)
    {
        min = i;
        for (int j = i + 1; j < n; j++)
        {
            if (a[min] > a[j])
                min = j;
        }
        if (min != i)
        {
            num++;
            swap(a[i], a[min]);
        }
    }
    cout << num << endl;
    return 0;
}
```

### C

```c
int main()
{
    int n;
    int num = 0;
    scanf("%d", &n);
    int a[n + 5];
    for (int i = 0; i < n; i++)
    {
        scanf("%d", &a[i]);
    }
    for (int i = 1; i < n; i++)
    {
        if (a[i - 1] > a[i])
        {
            swap(a[i - 1], a[i]);
            num++;
        }
    }
    if (num == n - 1)
    {
        num = n / 2;
    }
    cout << num << endl;
    return 0;
}
```
